/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/util/jmx/MBeanServerConnectionConnectionSource.java,v 1.3 2005/12/25 03:51:25 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:51:25 $
 */

package com.sun.appserv.management.util.jmx;

import java.io.IOException;

import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;

import com.sun.appserv.management.client.ConnectionSource;


/**
	A ConnectionSource which wraps an already created MBeanServerConnection
 */
public final class MBeanServerConnectionConnectionSource implements ConnectionSource
{
	protected MBeanServerConnection		mConn;
	
	/**
		Create a new instance for the specified MBeanServerConnection
	 */
		public
	MBeanServerConnectionConnectionSource( final MBeanServerConnection conn )
	{
		mConn	= conn;
	}
	
		public MBeanServerConnection
	getMBeanServerConnection( boolean forceNew )
		throws IOException
	{
		if ( mConn == null )
		{
			throw new IOException();
		}

		return( mConn );
	}
	
		public MBeanServerConnection
	getExistingMBeanServerConnection( )
	{
		return( mConn );
	}
	
	
		public JMXConnector
	getJMXConnector( boolean forceNew )
		throws IOException
	{
		// we can't supply one...
		return( null );
	}
}
