/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/util/misc/StringSource.java,v 1.3 2005/12/25 03:51:53 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:51:53 $
 */
 
package com.sun.appserv.management.util.misc;

/**
	An abstraction for getting a String, given an id string.
 */
public interface StringSource
{
	/**
		Get the String referred to by 'id'
		
		@param id	the id (key) for the String
		@return 	the String, or null if not found
	 */
	public String	getString( String id );
	
	/**
		Get the String referred to by 'id'.
		
		@param id			the id (key) for the String
		@param defaultValue	the default value to be returned if string was not found
		@return 			the String, or defaultValue if not found
	 */
	public String	getString( String id, String defaultValue );
};



