/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package com.sun.enterprise.admin.monitor.stats;
import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.CountStatistic;
import com.sun.enterprise.admin.monitor.stats.StringStatistic;

/**
 * A Stats interface, to expose the monitoring information 
 * about each individual thread in the the thread system of the JVM.
 * @since 8.1
 */
public interface JVMThreadInfoStats extends Stats {
    
    /**
     * Returns the Id of the thread
     * @return  CountStatistic  Id of the thread
     */
    public CountStatistic getThreadId();
    
    /**
     * Returns the name of the thread
     * @return  StringStatistic name of the thread
     */
    public StringStatistic getThreadName();
    
    /**
     * Returns the state of the thread
     * @return StringStatistic  Thread state
     */
    public StringStatistic getThreadState();
    
    /**
     * Returns the elapsed time (in milliseconds) that the thread associated 
     * with this ThreadInfo has blocked to enter or reenter a monitor since 
     * thread contention monitoring is enabled.
     * @return CountStatistic   time elapsed in milliseconds, since the thread
     *                          entered the BLOCKED state. Returns -1 if thread
     *                          contention monitoring is disabled
     */
     public CountStatistic getBlockedTime();
     
     /**
      * Returns the number of times that this thread has been in the blocked
      * state
      * @return CountStatistic  the total number of times that the thread 
      *                         entered the BLOCKED state
      */
     public CountStatistic getBlockedCount();
     
     /**
      * Returns the elapsed time(in milliseconds) that the thread has been in 
      * the waiting state.
      * @returns CountStatistic elapsed time in milliseconds that the thread has
      *                         been in a WAITING state. Returns -1 if thread
      *                         contention monitoring is disabled.
      */
     public CountStatistic getWaitedTime();
     
     /**
      * Returns the number of times that the thread has been in WAITING or 
      * TIMED_WAITING states
      * @return CountStatistic  total number of times that the thread was in
      *                         WAITING or TIMED_WAITING states
      */
     public CountStatistic getWaitedCount();
     
     /**
      * Returns the string representation of the monitor lock that the thread 
      * is blocked to enter or waiting to be notified through 
      * the Object.wait method
      * @return StringStatistic the string representation of the monitor lock
      */
     public StringStatistic getLockName();
     
     /**
      * Returns the Id of the thread which holds the monitor lock of an 
      * object on which this thread is blocking
      * @return CountStatistic Id of the thread holding the lock.
      */
     public CountStatistic getLockOwnerId();
     
     
     /**
      * Returns the name of the thread that holds the monitor lock of the 
      * object this thread is blocking on
      * @return StringStatistic name of the thread holding the monitor lock.
      */
     public StringStatistic getLockOwnerName();
     
     /**
      * Returns the stacktrace associated with this thread
      */
     public StringStatistic getStackTrace();
}
