/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * $Id: ThreadPoolStats.java,v 1.2 2005/12/25 03:52:27 tcfujii Exp $
 * $Date: 2005/12/25 03:52:27 $
 * $Revision: 1.2 $
 */

package com.sun.enterprise.admin.monitor.stats;
import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.BoundedRangeStatistic;
import javax.management.j2ee.statistics.RangeStatistic;

/**
 * Stats interface for the monitorable attributes of the
 * a generic ThreadPool. This combines the statistics that were exposed in 7.0
 * with the new ones. In 8.0, the generic Thread Pool that can be used by any component
 * in the server runtime is introduced.
 * @author Kedar Mhaswade
 * @since S1AS8.0
 * @version $Revision: 1.2 $
 */

public interface ThreadPoolStats extends Stats {
    
    /** Returns the statistical information about the number of Threads in the associated ThreaPool, as an instance of BoundedRangeStatistic.
     * This returned value gives an idea about how the pool is changing.
     * @return		an instance of {@link BoundedRangeStatistic}
     */
    public BoundedRangeStatistic getCurrentNumberOfThreads();
    
    /** Returns the total number of available threads, as an instance of {@link CountStatistic}.
     * @return		an instance of {@link CountStatistic}
     */
    public CountStatistic getNumberOfAvailableThreads();
    
    /** Returns the number of busy threads, as an instance of {@link CountStatistic}.
     * @return		an instance of {@link CountStatistic}
     */
    public CountStatistic getNumberOfBusyThreads();
    
    /**
     * Returns the statistical information about the average completion time of a work item in milliseconds.
     * @return	an instance of {@link RangeStatistic}
     */
    public RangeStatistic getAverageWorkCompletionTime();
    
    /** Returns the the total number of work items added so far to the work queue associated with threadpool.
     * @return		an instance of {@link CountStatistic}
     */
    public CountStatistic getTotalWorkItemsAdded();
    
    /**
     * Returns average time in milliseconds a work item waited in the work queue before getting processed.
     * @return		an instance of {@link RangeStatistic}
     */
    public RangeStatistic getAverageTimeInQueue();
}
