/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
* LineTokeReplacer.java
*/

package com.sun.enterprise.admin.util;

import java.io.File;
import java.io.Reader;
import java.io.Writer;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;

import com.sun.enterprise.admin.util.TokenValue;
import com.sun.enterprise.admin.util.TokenValueSet;

/**
 */
public final class LineTokenReplacer {
    
    private final TokenValue[]      tokenArray;
    
    /** Creates a new instance of TokenReplacer */
    public LineTokenReplacer(TokenValueSet tokens) {
            final Object[] tmp = tokens.toArray();
            final int length = tmp.length;
            this.tokenArray = new TokenValue[length];
            System.arraycopy(tmp, 0, tokenArray, 0, length);
    }
    public void replace(File inputFile, File outputFile) {
        //Edge-cases
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            reader = new BufferedReader(new FileReader(inputFile));
            writer = new BufferedWriter(new FileWriter(outputFile));
            String lineContents = null;
            while((lineContents = reader.readLine()) != null) {
                String modifiedLine = replaceLine(lineContents);
                writer.write(modifiedLine);
                writer.newLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (reader != null)
                    reader.close();
                if (writer != null)
                    writer.close();
            }
            catch(Exception e) {}
        }
    }
    
    public void replace(String inputFileName, String outputFileName) {
        this.replace(new File(inputFileName), new File(outputFileName));
    }
    
    private String replaceLine(String lineWithTokens) {
        String tokenFreeString = lineWithTokens;
        
        for (int i = 0 ; i < tokenArray.length ; i++) {
            TokenValue aPair        = tokenArray[i];
            //System.out.println("To replace: " + aPair.delimitedToken);
            //System.out.println("Value replace: " + aPair.value);
            tokenFreeString = tokenFreeString.replaceAll(aPair.delimitedToken,
                aPair.value);
        }
        return ( tokenFreeString );
    }
}
