/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ActionMenuHandlers.java
 *
 * Created on May 20, 2004, 10:26 AM
 */

package com.sun.enterprise.tools.admingui.handlers;


import com.iplanet.jato.RequestContext;
import com.iplanet.jato.view.View;

import javax.management.ObjectName;
import javax.management.AttributeList;
import javax.management.Attribute;

import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.descriptors.CCActionTableDescriptor;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.iplanet.jato.view.ViewBean;

import com.sun.web.ui.model.CCActionTableModelInterface;

import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;

public class ActionMenuHandlers {
    
    public void handleClusterResourcesActions(RequestContext ctx, HandlerContext handlerCtx) 
            throws Exception{
        String action = (String)handlerCtx.getInputValue("action");

        ViewDescriptor desc = null;
        View tableView = handlerCtx.getView().getParent();
        desc = ((DescriptorContainerView)tableView).getViewDescriptor();
        CCActionTableDescriptor ccDesc = (CCActionTableDescriptor)desc;
        
        CCActionTableModelInterface model = ccDesc.getModel();
        setAttributeForSelectedRows(model, action);
    }
    
    public void forwardToApplicationPage(RequestContext ctx, HandlerContext handlerCtx) {
	String type = (String)handlerCtx.getInputValue("type");
	String forwardPage = "upload";
	
	if(type == null) {
	    throw new FrameworkException("type is null in forwardTo TargetHandler:", null,handlerCtx.getView());
	}
	
	if(type.equals("lifecycleModulesCreate")) {
	    forwardPage = type;
	}
	else {
	    ctx.getRequest().setAttribute("AppType", type);
	}
	
	ViewBean viewBean = null;
	try {
		viewBean = ctx.getViewBeanManager().getViewBean(forwardPage);
	} 
	catch(Exception ex) {
	    throw new FrameworkException("Unable get ViewBean:"+forwardPage, null, handlerCtx.getView());
	}
	
	viewBean.forwardTo(ctx);
	
    }

    
    private void setAttributeForSelectedRows(CCActionTableModelInterface model,
            String action) throws Exception {
	model.setRowSelectionType("multiple");
        model.beforeFirst();
        // from the model, get the child that has the needed value...
        while(model.next()) {
            String currentObj = (String)model.getValue("objectName");
	    if(model.isRowSelected()) {
                ObjectName refsObj = new ObjectName((String)model.getValue("objectName"));
                String type = refsObj.getKeyProperty("type");
                
                if (type.equals("application-ref")){
                    String editKeyValue = refsObj.getKeyProperty("ref");
                    String target = refsObj.getKeyProperty("server");
                    if (Util.isEmpty(target)){
                        target = refsObj.getKeyProperty("cluster");
                    }
                    DeploymentHandler.changeEnableStatus(editKeyValue, new String[] { target }, action);
                }else
                if (type.equals("resource-ref")){
                    TargetHandlers.changeEnableStatus(refsObj, action);
                }else
                    throw new FrameworkException("Error in setAttributeForSelectedRows: wrong type ");
                model.setRowSelected(false);
	    }
        }
    }
}


