/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ConnectorConnectionPoolHandlers.java
 *
 * Created on November 26, 2003, 2:35 PM
 */

package com.sun.enterprise.tools.admingui.handlers;

import java.util.EventObject;
import javax.servlet.http.HttpSession;
import javax.management.AttributeList;
import javax.management.Attribute;
import java.util.Properties;
import java.util.Enumeration;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.ViewBase;
import com.iplanet.jato.view.html.SelectableGroup;
import com.iplanet.jato.view.html.OptionList;

import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.model.ModelManager;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;

import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;

/**
 *
 * @author  sirajg
 */
public class ConnectorConnectionPoolHandlers {
    
    public static final String	PROPERTY_NAME	= "propertyName";
    public static final String	PROPERTY_VALUE 	= "propertyValue";
    
    /* called from step2, to get values from step1 */
    public void getValuesFromStep1(RequestContext ctx, HandlerContext handlerCtx) throws ModelControlException {
        View view = handlerCtx.getView();
	DescriptorContainerView descView = (DescriptorContainerView)(((ViewBase)view));
	ViewDescriptor vd = descView.getViewDescriptor();
	HttpSession session = RequestManager.getSession();
        DefaultModel step1Model = (DefaultModel)(session.getValue("connectorPoolStep1.model"));
        descView.setDisplayFieldValue("Name", step1Model.getValue("Name"));
        descView.setDisplayFieldValue("ResourceAdapter", step1Model.getValue("ResourceAdapter"));
        descView.setDisplayFieldValue("ConnectionDefinition", step1Model.getValue("ConnectionDefinition"));
    }
    

    /* gets default properties for given resource adapter and connectiondefinition */
    public void populateDefaultProperties(RequestContext ctx, HandlerContext handlerCtx) 
            throws ModelControlException {
        View view = handlerCtx.getView();
	DescriptorContainerView descView = (DescriptorContainerView)(((ViewBase)view));
        DescriptorContainerView parent = (DescriptorContainerView)descView.getParent();
        String connectionDefinition = (String)parent.getDisplayFieldValue("ConnectionDefinition");
        String resourceAdapter = (String)parent.getDisplayFieldValue("ResourceAdapter");
        AttributeList attrList = new AttributeList();
        attrList.add(new Attribute("resource-adapter-name", resourceAdapter));
        attrList.add(new Attribute("connection-definition-name", connectionDefinition));
        Object[] params = new Object[]{attrList};
        String[] types = new String[]{"javax.management.AttributeList"};
        
        Properties properties = 
                (Properties)MBeanUtil.invoke("com.sun.appserv:type=resources,category=config",
                                 "getMCFConfigProps",
                                 params, types );
        CCActionTableModelInterface model =
            (CCActionTableModelInterface)handlerCtx.getInputValue("propertiesModel");
        ((DefaultModel)model).clear();
        if (properties == null)
            return;
        model.beforeFirst();
        Enumeration propertyNames = properties.propertyNames();
        while(propertyNames.hasMoreElements()){
            model.appendRow();
            String name = (String)propertyNames.nextElement();
            model.setValue(PROPERTY_NAME, name);
            model.setValue(PROPERTY_VALUE, properties.getProperty(name));
            model.setRowSelected(false);
        }
    }

    /* gets connectiondefinition for given resource adapter */
    public void populateConnectionDefinitions(RequestContext ctx, HandlerContext handlerCtx) throws ModelControlException {
        View view = handlerCtx.getView();
        // the child should be something like: com.sun.web.ui.view.html.CCDropDownMenu
        SelectableGroup dropDownChild = (SelectableGroup) view;
        // get the parent container of the dropdown
        DescriptorContainerView parent = (DescriptorContainerView) dropDownChild.getParent();
        String resAdapter = (String)parent.getDisplayFieldValue("ResourceAdapter");
        Object[] params = {resAdapter};
        String[] types = {"java.lang.String"};
        String[] connectionDefinitions = 
                (String[])MBeanUtil.invoke("com.sun.appserv:type=resources,category=config",
                                 "getConnectionDefinitionNames",
                                 params, types );
        if (connectionDefinitions == null)
            return;
        OptionList dropDownMenuOptions = new OptionList(connectionDefinitions, connectionDefinitions ); // label and values
        dropDownChild.setOptions(dropDownMenuOptions);
    }

    /* if default properties should be reloaded, sets 'connectorPoolStep3.areDefaultPropertiesLoaded'
     * to true, otherwise to false */
    public void areDefaultPropertiesLoaded(RequestContext ctx, HandlerContext handlerCtx) throws ModelControlException {
        View view = handlerCtx.getView();
	DescriptorContainerView descView = (DescriptorContainerView)(((ViewBase)view));
        DescriptorContainerView parent = (DescriptorContainerView)descView.getParent();
        String newConnectionDefinition = (String)parent.getDisplayFieldValue("ConnectionDefinition");
        HttpSession session = RequestManager.getSession();
        String oldConnectionDefinition = (String)session.getAttribute("connectorPoolStep3.ConnectionDefinition");
        if (oldConnectionDefinition == null || 
            !oldConnectionDefinition .equals(newConnectionDefinition)) {
            ctx.getRequest().setAttribute("connectorPoolStep3.areDefaultPropertiesLoaded", "false");
        }
        else {
            ctx.getRequest().setAttribute("connectorPoolStep3.areDefaultPropertiesLoaded", "true");
        }
        session.setAttribute("connectorPoolStep3.ConnectionDefinition", newConnectionDefinition);
    }
    
}
