/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * LogModuleHandler.java
 *
 */

package com.sun.enterprise.tools.admingui.handlers;

import java.util.ArrayList;
import java.util.List;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.view.DisplayField;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBase;
import com.iplanet.jato.view.html.SelectableGroup;
import javax.management.Attribute;



import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;

import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;

/**
 *
 */
public class LogModuleHandler {

     public void showPersistenceLogLevel(RequestContext ctx, HandlerContext handlerCtx) {
        // the child should be something like: com.sun.web.ui.view.html.CCDropDownMenu
        SelectableGroup dropDownChild = (SelectableGroup)handlerCtx.getInputValue(DISPLAY_FIELD);
        String objectName = (String) handlerCtx.getInputValue("objectName");
        //show the property value set by the property "oracle.toplink.essentials"
        String[] types = new String[]{"java.lang.String"};
        Object[] params = new Object[]{PERSISTENCE_MODULE_PROPERTY};
        String value = "INFO";
        try {
            value = (String) MBeanUtil.invoke(objectName, "getPropertyValue", params, types);
        }catch (Exception ex){
            //ignore exception if the property doesn't exist
        }
        dropDownChild.setValue(value);
     }
     
     public void setPersistenceLogLevel(RequestContext ctx, HandlerContext handlerCtx) {
        // the child should be something like: com.sun.web.ui.view.html.CCDropDownMenu
        String objectName = (String) handlerCtx.getInputValue("objectName");
        String value = (String) handlerCtx.getInputValue("value");
        //set the property value set of "oracle.toplink.essentials"
        Attribute attr = new Attribute(PERSISTENCE_MODULE_PROPERTY, value);
        String[] types = new String[]{"javax.management.Attribute"};
        Object[] params = new Object[]{attr};
        MBeanUtil.invoke(objectName, "setProperty", params, types);
        
        attr = new Attribute("jdo", value);
        MBeanUtil.setAttribute(objectName, attr);
        
        attr = new Attribute("cmp", value);
        MBeanUtil.setAttribute(objectName, attr);
        
        attr = new Attribute("cmp-container", value);
        MBeanUtil.setAttribute(objectName, attr);
     }
     
     
     public void showPersistenceLogModule(RequestContext ctx, HandlerContext handlerCtx) {
        // the child should be something like: com.sun.web.ui.view.html.CCDropDownMenu
        DisplayField field = (DisplayField)handlerCtx.getInputValue(DISPLAY_FIELD);
        String jdo = getLoggerList("jdo", field.getName());
        String cmp = getLoggerList("cmp", field.getName());
        field.setValue( "( " + PERSISTENCE_MODULE_PROPERTY + "; " + jdo + cmp +  ")" );
     }
     
     public void showModuleLogger(RequestContext reqCtx, HandlerContext handlerCtx) {
         // Get the attribute names
	ArrayList attributeNames = (ArrayList)handlerCtx.getInputValue("attributeNames");
	if (attributeNames == null) {
	    throw new IllegalArgumentException(
		"The parameter map did not contain " + "attributeNames");
	}

	// Get the display field names
	ArrayList displayNames = (ArrayList)handlerCtx.getInputValue("displayNames");
	if (displayNames == null) {
	    throw new IllegalArgumentException(
		"The parameter map did not contain " + "displayNames");
	}

	// Get the view which holds the display fields to set
	ContainerView view = MBeanHandlers.getView(reqCtx, handlerCtx);
        
        for (int i=0; i < displayNames.size(); i++) {
            String module = (String) attributeNames.get(i);
            String label = displayNames.get(i)+"Label";
            String logList = getLoggerList(module, label);
//            view.setDisplayFieldValue(label, module + logList);
            view.setDisplayFieldValue(label, "( " + logList + ")");
        }
    }
     
     private String getLoggerList(String module, String label ){
        String[] params = {module};
        String[] types = {"java.lang.String"};

        String logList = "";
        List loggers = (List) MBeanUtil.invoke(
                "com.sun.appserv:name=logmanager,category=runtime,server=server",
                "getLognames4LogModule", params, types);
        
        if (loggers != null){
            for(int cnt = 0; cnt < loggers.size(); cnt++){
                logList += loggers.get(cnt);
                logList +="; ";
            }
        }
        
        return logList;
     }
     
     
     private static final String PERSISTENCE_MODULE_PROPERTY  = "oracle.toplink.essentials";
     private static final String DISPLAY_FIELD	= "displayField";
}
