/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.admingui.handlers;

import java.util.EventObject;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.View;

import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;

import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;


/**
 * PersistenceHandlers.java
 */
public class PersistenceHandlers {

    public void getConnectionPool(RequestContext ctx, HandlerContext handlerCtx) throws Exception {
	View view = handlerCtx.getView();
        DescriptorContainerView descView = (DescriptorContainerView)(view.getParent());
        String objectName = (String) handlerCtx.getInputValue("objectName");
        if (objectName == null) {
            return;
	}
	if (Util.isLoggableFINEST()) {
	    Util.logFINEST("PM : objectname = " + objectName);
	}
        Object jdbcResource = MBeanUtil.getAttribute(objectName, "jdbc-resource-jndi-name");
	if (Util.isLoggableFINEST()) {
	    Util.logFINEST("PM : jdbc = " + jdbcResource);
	}
        if (jdbcResource != null) {
            String jdbcObjectName = "com.sun.appserv:type=jdbc-resource,category=config,jndi-name=" + jdbcResource.toString();
            //mbean will thrown not found exception if user deleted the jdbc resource on purpose,
            // but the attribute is still pointing to the jdbc resource
            try {
                descView.setDisplayFieldValue("ConnectionPool", MBeanUtil.getAttribute(jdbcObjectName, "pool-name"));
            }catch (Exception ex){
                //ignore
            }
        }
    }
}
