/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * addRemoveHandlers.java
 *
 * Created on March 16, 2004, 12:34 PM
 */

package com.sun.enterprise.tools.admingui.handlers;

import java.util.StringTokenizer;
import java.util.List;
import java.util.Arrays;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import java.util.Properties;
import java.util.HashMap;
import java.util.Enumeration;

import javax.servlet.http.HttpServletRequest;

import javax.management.ObjectName;
import javax.management.Attribute;
import javax.management.AttributeList;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.view.*;
import com.sun.web.ui.taglib.html.*;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBase;
import com.iplanet.jato.view.html.StaticTextField;
import com.iplanet.jato.view.html.HREF;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.jato.view.event.ChildContentDisplayEvent;

import com.sun.web.ui.model.CCAddRemoveModelInterface;
import com.sun.web.ui.view.addremove.CCAddRemove;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.model.CCActionTableModelInterface;

import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.enterprise.tools.guiframework.view.event.BeforeCreateEvent;
import com.sun.enterprise.tools.guiframework.view.descriptors.CCAddRemoveDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.CCPropertySheetDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.CCActionTableDescriptor;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.event.handlers.AttributeHandlers;

import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.admingui.ConfigProperties;


import com.sun.enterprise.admin.servermgmt.RuntimeStatusList;
import com.sun.enterprise.admin.servermgmt.RuntimeStatus;
import com.sun.enterprise.admin.common.Status;


public class TargetHandlers {

    // Show or not to show the targets section of the property sheet.
    // In PE we don't and in SE/EE we do.
    public void setupTargetsSection(RequestContext ctx, HandlerContext handlerCtx) {
        ViewDescriptor vd;
        if (handlerCtx.getEvent() instanceof BeforeCreateEvent) {
            vd = ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor();
        }
        else {
            vd = handlerCtx.getViewDescriptor();
        }
        
        if (vd instanceof CCPropertySheetDescriptor) {
            CCPropertySheetModelInterface model = 
                ((CCPropertySheetDescriptor)vd).getModel();
            String targetsSectionName = (String)handlerCtx.getInputValue("targetsSectionName");
            Boolean hasTargets = ConfigProperties.getInstance().getTargetSupported();
            if (targetsSectionName != null) {
                model.setVisible(targetsSectionName, hasTargets.booleanValue());
                handlerCtx.setOutputValue("hasTargets", hasTargets);
            }
            else {
                handlerCtx.setOutputValue("hasTargets", new Boolean(false));
            }
        } else {
            throw new RuntimeException("ViewDesc should be of type property sheet.");
        }
    }

    public void setAvailableList(RequestContext ctx, HandlerContext handlerCtx) {
        ViewDescriptor vd;
        if (handlerCtx.getEvent() instanceof BeforeCreateEvent) {
            vd = ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor();
        } 
        else {
            vd = handlerCtx.getViewDescriptor();
        }
        if (vd instanceof CCAddRemoveDescriptor) {
            ObjectName[] clusters = (ObjectName[])handlerCtx.getInputValue("clusters");
            ObjectName[] instances = (ObjectName[])handlerCtx.getInputValue("instances");
            String[] names = getAllTargets(clusters, instances);
            CCAddRemoveModelInterface model = ((CCAddRemoveDescriptor)vd).getModel();
            CCAddRemoveDescriptor addRemoveDesc = (CCAddRemoveDescriptor)vd;
            String defaultInstance = (String)handlerCtx.getInputValue("defaultInstance");
            String defaultCluster = (String)handlerCtx.getInputValue("defaultCluster");
            String defaultTarget = null;
            Vector vv = new Vector(Arrays.asList(names));
            if (!Util.isEmpty(defaultInstance)){
                vv.remove(defaultInstance);
                defaultTarget = defaultInstance;
            }
            if (!Util.isEmpty(defaultCluster)){
                vv.remove(defaultCluster);
                defaultTarget = defaultCluster;
            }
            if (defaultTarget != null){
                names = new String[vv.size()];
                for(int i=0; i<vv.size(); i++){
                    names[i] = (String) vv.elementAt(i);
                }
                model.setSelectedOptionList(new OptionList(new String[]{defaultTarget}, new String[]{defaultTarget}));
            }
            model.setAvailableOptionList(new OptionList(names, names));
        } else {
            throw new RuntimeException("Not an AddRemoveComponent!");

        }
    }
    public void setAllTargets(RequestContext ctx, HandlerContext handlerCtx) {
	ObjectName[] clusters = (ObjectName[])handlerCtx.getInputValue("clusters");
	ObjectName[] instances = (ObjectName[])handlerCtx.getInputValue("instances");
	
	String[] allTargets = getAllTargets(clusters, instances);
	handlerCtx.setOutputValue("allTargets", allTargets);
    }
    
    private String[] getAllTargets(ObjectName[] clusters, ObjectName[] instances) {
	int clusterCount = (clusters == null)?(0):(clusters.length);
	int instanceCount = (instances == null)?(0):(instances.length);
	
	String[] allTargets = new String[clusterCount + instanceCount];
        int i;
        for (i = 0; i < clusterCount; i++) {
	    allTargets[i] = (String)MBeanUtil.getAttribute(clusters[i], "name");
        }
        for (i = 0; i < instanceCount; i++) {
	    allTargets[i+clusterCount] = (String)MBeanUtil.getAttribute(instances[i], "name");
        }
	return allTargets;
    }
    
     public void setSelectedTargets(RequestContext ctx, HandlerContext handlerCtx) {
        ViewDescriptor vd;
        if (handlerCtx.getEvent() instanceof BeforeCreateEvent) {
            vd = ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor();
        } 
        else {
            vd = handlerCtx.getViewDescriptor();
        }
        if (vd instanceof CCAddRemoveDescriptor) {
            String[] targets = (String[])handlerCtx.getInputValue("targets");
	    String objectName = (String)handlerCtx.getInputValue("objectName");
	    Object refName = (Object)handlerCtx.getInputValue("referedTargets");
            String key = (String)handlerCtx.getInputValue("key");
            if(key == null)
                key = "name";
                        
            if (targets == null) {
		targets = new String[0];
	    }
            String[] associatedTargets = null;
            if(refName == null){
                refName = new String[0];
            }
            if (refName instanceof ObjectName[]) {
                associatedTargets = getAssociatedTargets((ObjectName[])refName, key);
            } else if (refName instanceof String[]) {
                associatedTargets = (String[])refName;           
            }
          
	    targets = getAvailableVirtualServers(targets, associatedTargets);
            
	    CCAddRemoveDescriptor addRemoveDesc = (CCAddRemoveDescriptor)vd;
            CCAddRemoveModelInterface model = addRemoveDesc.getModel();

	    model.setAvailableOptionList(new OptionList(targets, targets));
	    model.setSelectedOptionList(new OptionList(associatedTargets, associatedTargets));
        } else {
            throw new RuntimeException("Not an AddRemoveComponent!");

        }
    }
     
    
    private String[] getAssociatedTargets(ObjectName[] refName, String key) {
	String[] associatedTargets = (refName != null) ? new String[refName.length]:new String[0];
	
	for (int i=0; refName != null && i < refName.length; i++) {
	    associatedTargets[i] = refName[i].getKeyProperty(key);
	}
	return associatedTargets;
    }    
    
    public void setAvailableVirtualServers(RequestContext ctx, HandlerContext handlerCtx) {
        ViewDescriptor vd;
        if (handlerCtx.getEvent() instanceof BeforeCreateEvent) {
            vd = ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor();
        } 
        else {
            vd = handlerCtx.getViewDescriptor();
        }
        if (vd instanceof CCAddRemoveDescriptor) {
            ObjectName[] virtualServers = (ObjectName[])handlerCtx.getInputValue("virtualServers");
	    String objectName = (String)handlerCtx.getInputValue("objectName");
            int vsCount = (virtualServers == null)?(0):(virtualServers.length);
            
            String[] availableVS = new String[vsCount];
            for (int i = 0; i < vsCount; i++) {
                availableVS[i] = (String)MBeanUtil.getAttribute(virtualServers[i], "id");
            }
            
	    CCAddRemoveDescriptor addRemoveDesc = (CCAddRemoveDescriptor)vd;
            CCAddRemoveModelInterface model = addRemoveDesc.getModel();
	    String[] selectedVS = getAssociatedVirtualServers(objectName);
	
	    if (selectedVS == null || selectedVS.length == 0) {
		selectedVS = availableVS;
		availableVS = new String[0];
	    }
	    else {
		availableVS = getAvailableVirtualServers(availableVS, selectedVS);
	    }
	    model.setAvailableOptionList(new OptionList(availableVS, availableVS));
	    model.setSelectedOptionList(new OptionList(selectedVS, selectedVS));
        } else {
            throw new RuntimeException("Not an AddRemoveComponent!");

        }
    }
    // we may need to move this to Util class.
    private String[] getAvailableVirtualServers(String[] availableVS, String[] selectedVS) {
	    Vector availableVector = new Vector();
	    boolean selected = false;
	    
	    for(int i=0; i < availableVS.length; i++) {
		for(int j=0; j < selectedVS.length; j++) {
		    if(availableVS[i].equals(selectedVS[j])) {
			selected = true;
			break;
		    }
		}
		if(!selected) {
		    availableVector.add(availableVS[i]);
		}
		selected = false;
	    }
	    availableVS = (String[])availableVector.toArray(new String[availableVector.size()]);
	    return availableVS;
    }
    
    private String[] getAssociatedVirtualServers(String objectName) {
	String str = (String)MBeanUtil.getAttribute(objectName, "virtual-servers");
	String[] vs = Util.stringToArray(str, ",");
	return vs;
    }
    
    public void setVirtualServerAttribute(RequestContext ctx, HandlerContext handlerCtx) {
	String objectName = (String)handlerCtx.getInputValue("objectName");
	String[] targets = (String[])handlerCtx.getInputValue("targets");
	String virtualServers = Util.concatDelimiter(targets, ",");
	Attribute attr = new Attribute("virtual-servers", virtualServers);
	MBeanUtil.setAttribute(objectName, attr);
    }

    public void getSelectedTargets(RequestContext ctx, HandlerContext handlerCtx) {
	String childName = (String)handlerCtx.getInputValue("targetsChildName");
        if (childName == null || childName.length() == 0) {
            return;
        }
        
	View view = handlerCtx.getView();
	DescriptorContainerView descView = (DescriptorContainerView)
	    (((ViewBase)view).getParentViewBean());
	ViewDescriptor vd = descView.getViewDescriptor();
	ViewDescriptor desc = vd.getChildDescriptor(childName);
	if (!(desc instanceof CCAddRemoveDescriptor)) {
	    throw new FrameworkException("addRemoveDescriptor is of wrong type", desc, view);
	}
        CCAddRemoveDescriptor addRemoveDesc = ((CCAddRemoveDescriptor)desc);
        CCAddRemoveModelInterface model = addRemoveDesc.getModel();
        CCAddRemove addRemoveChild = (CCAddRemove)addRemoveDesc.getView(ctx);
        
        // DON'T DO THIS:
        // CCAddRemove addRemoveChild = (CCAddRemove)(descView.getChild(childName));
        // THIS CAUSES A NEW CCAddRemove CHILD TO BE CREATED, WITH A NEW MODEL
        // AND THE MODEL HASN'T HAD THE REQUEST VALUES MAPPED TO IT!!!!!
        
        OptionList selectedOptions = model.getSelectedOptionList(addRemoveChild);
	OptionList availableOptions = model.getAvailableOptionList(addRemoveChild);
        if (selectedOptions ==  null) 
            selectedOptions = model.getSelectedOptionList();
	if (availableOptions ==  null) 
            availableOptions = model.getAvailableOptionList();
        
        String[] targets = null;
        if (selectedOptions != null) {
            targets = new String[selectedOptions.size()];
            for (int i = 0; i < targets.length; i++) {
                targets[i] = selectedOptions.getValue(i);
            }
        }
	//Using the above method to get the available lists also, to manage targets.
	String[] availableTargets = null;
        if (availableOptions != null) {
            availableTargets = new String[availableOptions.size()];
            for (int i = 0; i < availableTargets.length; i++) {
                availableTargets[i] = availableOptions.getValue(i);
            }
        }
        handlerCtx.setOutputValue("targets", targets);
	handlerCtx.setOutputValue("availableTargets", availableTargets);
    }
    
    public void createReferences(RequestContext ctx, HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue("objectName");
        String methodName = (String)handlerCtx.getInputValue("methodName");
        String key = (String)handlerCtx.getInputValue("key");
        String[] targets = (String[])handlerCtx.getInputValue("targets");
        String[] types= new String[]{"java.lang.String", "boolean", "java.lang.String"};
        if (targets != null) {
            for (int i = 0; i < targets.length; i++) {
                Object[] params = new Object[]{targets[i], new Boolean(true), key};
                MBeanUtil.invoke(objectName, methodName, params, types);
            }
        }
    }
	//Need to write a new method to create references, bcz the params are hard coded in the above createReferences method.
    public void createMBeanWithReferences(RequestContext ctx, HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue("objectName");
        String methodName = (String)handlerCtx.getInputValue("methodName");
        ArrayList typesList= (ArrayList)handlerCtx.getInputValue("types");
	ArrayList paramsList = (ArrayList)handlerCtx.getInputValue("params");
        String[] targets = (String [])handlerCtx.getInputValue("targets");
	String[] types = (String[])typesList.toArray(new String[typesList.size()]);
        Boolean isTargetSupported = ConfigProperties.getInstance().getTargetSupported();
        
        if(targets == null || targets.length == 0) {
     		//By default deploying to DAS to be in sync. with CLI.
     		targets = new String[]{"server"};
     	}
        
        Map attrsMap = (Map) paramsList.get(0);
        
        if(isTargetSupported){
            String enabled = (String)attrsMap.get("EEenabled");
            if (Util.isEmpty(enabled)) enabled="true";
            attrsMap.put("enabled", enabled);
        }else{
            String enabled = (String)attrsMap.get("PEenabled");
            if (Util.isEmpty(enabled)) enabled="true";
            attrsMap.put("enabled", enabled);
        }
        attrsMap.remove("PEenabled");
        attrsMap.remove("EEenabled");
        for (int i = 0; i < targets.length; i++) {
		paramsList.add(0, targets[i]);
		Object[] params = paramsList.toArray();
                MBeanUtil.invoke(objectName, methodName, params, types);
                paramsList.remove(0);
                String objName="com.sun.appserv:type=application-ref,category=config,ref=" + attrsMap.get("name")+ ",server="+ targets[i];
                //the following can be removed after bug#6342989 is fixed
                Attribute attr = new Attribute("enabled", attrsMap.get("enabled"));
                MBeanUtil.setAttribute(objName, attr);
        }
        
        // set Description
        if(! Util.isEmpty( (String) attrsMap.get("description"))){
            Attribute desc = new Attribute("description", attrsMap.get("description"));
            MBeanUtil.setAttribute("com.sun.appserv:type=mbean,category=config,name="+attrsMap.get("name"), desc);
        }
        
    }
  
    public void deleteReferences(RequestContext ctx, HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue("objectName");
        String methodName = (String)handlerCtx.getInputValue("methodName");
        String key = (String)handlerCtx.getInputValue("key");
        String[] targets = (String[])handlerCtx.getInputValue("availableTargets");
        String[] types= new String[]{"java.lang.String", "java.lang.String"};
        if (targets != null) {
            for (int i = 0; i < targets.length; i++) {
                Object[] params = new Object[]{targets[i],key};
                MBeanUtil.invoke(objectName, methodName, params, types);
            }
        }
    }

    public void deleteLBReferences(RequestContext ctx, HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue("objectName");
        String methodName = (String)handlerCtx.getInputValue("methodName");
        String key = (String)handlerCtx.getInputValue("key");
        String[] deleteTargets = (String[])handlerCtx.getInputValue("availableTargets");
        String[] types= new String[]{"java.lang.String"};
        
        if(deleteTargets != null) {
            for (int i = 0; i < deleteTargets.length; i++) {
                Object params[] = {deleteTargets[i]};
                MBeanUtil.invoke(objectName, methodName, params, types);
            }
        }
    }
        
    public void createLBReferences(RequestContext ctx, HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue("objectName");
        String methodName = (String)handlerCtx.getInputValue("methodName");
        String key = (String)handlerCtx.getInputValue("key");
        String[] targets = (String[])handlerCtx.getInputValue("targets");
        Object objName = null;
        if (targets != null ) {
            for (int i = 0; i < targets.length; i++) {
                String[] types2= new String[]{"java.lang.String"};
                Object params2[] = {targets[i]};
                try {                
                    objName = MBeanUtil.invoke(objectName, "getClusterRefByRef", params2, types2);
                } catch (Exception ex) {
                    // ignore
                }                
                if(objName == null) {
                    String[] types= new String[]{"javax.management.AttributeList"};
                    AttributeList attrList = new AttributeList();                
                    attrList.add(new Attribute("ref", targets[i]));
                    Object params[] = {attrList};
                    MBeanUtil.invoke(objectName, methodName, params, types);
                }
                
            }
        } 
    }
    
    
//    // FIXME: a cluster list should be passed in from XML calling MBean.invoke.
//    // FIXME: Shouldn't have MBEan names in XML.
//    private String[] getClusters() {
//        ObjectName[] clusters =  
//            (ObjectName[]) MBeanUtil.invoke(
//                "com.sun.appserv:type=clusters,category=config",
//                "listClusters",
//                new Object[]{null},
//                new String[]{"java.lang.String"});
//        String[] clusterNames= new String[clusters.length];
//        for (int i = 0; i < clusters.length; i++) {
//            clusterNames[i] = (String)MBeanUtil.getAttribute(clusters[i], "name");
//        }
//        return clusterNames;
//    }
//    
//    private boolean isCluster(String name) {
//        String[] clusters = getClusters();
//        for (int i = 0; i < clusters.length; i++) {
//            if (clusters[i].equals(name))
//                return true;
//        }
//        return false;
//    }
//    
//    // FIXME : work on getting a more efficient way to select the page to go to 
//    public void TargetHrefClicked(RequestContext ctx, HandlerContext handlerCtx) {
//        HREF href = (HREF)handlerCtx.getView();
//        String nextPage;
//        
//        if (isCluster(href.getValue().toString())) {
//            nextPage = "cluster";
//        }
//        else {
//            nextPage = "serverInstance";
//        }
//        handlerCtx.setOutputValue("nextPage", nextPage);
//    }
    public void getRequiredTargets(RequestContext ctx, HandlerContext handlerCtx) {
       Object objectName = (Object)handlerCtx.getInputValue("ObjectName");
        String[] targets = (String[])handlerCtx.getInputValue("availableTargets"); //available targets from addremove comp.
	String[] allTargets = (String[])handlerCtx.getInputValue("targetList");
        String key = (String)handlerCtx.getInputValue("key");       
	HashMap availableTargetsList = Util.stringArrayToHashMap(targets);
	Vector deleteTargets = new Vector();
	Vector createTargets = new Vector();
        if(key == null)
            key = "name";     
        String[] instanceName = null;
        if (objectName instanceof ObjectName[]) {
            instanceName = getAssociatedTargets((ObjectName[])objectName, key);      
        } else if (objectName instanceof String[]) {
            instanceName = (String[])objectName;
        }        
        HashMap instancesList = Util.stringArrayToHashMap(instanceName);         

 //current associated instance list.
	
	for (int i=0; allTargets != null && i < allTargets.length; i++) {
	    //Delete only if necessary
	    if(availableTargetsList.containsKey(allTargets[i]) && instancesList.containsKey(allTargets[i])) {
		deleteTargets.add(allTargets[i]);
	    }
	    //Create only if necessary
	    if(!availableTargetsList.containsKey(allTargets[i]) && !instancesList.containsKey(allTargets[i])) {
		createTargets.add(allTargets[i]);
	    }
	}
	handlerCtx.setOutputValue("deleteTargets", (String[])deleteTargets.toArray(new String[deleteTargets.size()]));
	handlerCtx.setOutputValue("createTargets", (String[])createTargets.toArray(new String[createTargets.size()]));
    }
    
    public void beginDisplayTargetPlaceHolder(RequestContext ctx, HandlerContext handlerCtx) {
        StaticTextField field = (StaticTextField)handlerCtx.getView();
        field.setValue(".TARGETVALUE.");
    }
    
    public void beginDisplayTargetsInTable(RequestContext ctx, HandlerContext handlerCtx) {
        HREF href = (HREF)handlerCtx.getView();
        href.setValue(".TARGETVALUE.");
    }
    
    public String endDisplayTargetsInTable(RequestContext ctx, HandlerContext handlerCtx) {
	if (!(handlerCtx.getEvent() instanceof ChildContentDisplayEvent)) {
	    return null;
	}
	ChildContentDisplayEvent dispEvent = (ChildContentDisplayEvent)handlerCtx.getEvent();
	String content = dispEvent.getContent();
        ObjectName[] targets = (ObjectName[])handlerCtx.getInputValue("targets");
        String key = (String)handlerCtx.getInputValue("key");
        if(key == null)
            key = "name";
        
        String hrefs = "";
        if (targets != null) {
            for (int i = 0; i < targets.length; i++) {
                if (i > 0)
                    hrefs += "<br />";
                
                String objectType = targets[i].getKeyProperty("type");
                String isCluster = (objectType.equalsIgnoreCase("cluster"))?"true":"false";               
                String statusIcon = getStatusIconHtml(targets[i]);

                String tmp = content.replaceFirst(".TARGETVALUE.", 
                    (String)MBeanUtil.getAttribute(targets[i], key)+"&isCluster="+isCluster);
                hrefs += statusIcon + tmp.replaceAll(".TARGETVALUE.", 
                    (String)MBeanUtil.getAttribute(targets[i], key));
            }
        }
        return hrefs;
    }
    
    public String endDisplayLBsInTable(RequestContext ctx, HandlerContext handlerCtx) {
	if (!(handlerCtx.getEvent() instanceof ChildContentDisplayEvent)) {
	    return null;
	}
	ChildContentDisplayEvent dispEvent = (ChildContentDisplayEvent)handlerCtx.getEvent();
	String content = dispEvent.getContent();
        String[] targets = (String[])handlerCtx.getInputValue("targets");
        ObjectName[] lbs = (ObjectName[])handlerCtx.getInputValue("lbs");        
        String key = (String)handlerCtx.getInputValue("key");
        if(key == null)
            key = "name";
        String hrefs = "";

        if (targets != null && lbs != null) {
            for (int i = 0; i < targets.length; i++) {
                String lbConfig = "";
                String name = "";
                if (i > 0)
                    hrefs += "<br />";
                for(int j = 0; j < lbs.length; j++){
                    lbConfig = (String)MBeanUtil.getAttribute(lbs[j].toString(), "lb-config-name");
                    if(targets[i].equals(lbConfig)) {
                        name = lbs[j].getKeyProperty("name");
                    }
                }
                
                String tmp = content.replaceFirst(".TARGETVALUE.",
                name);
                hrefs += tmp.replaceAll(".TARGETVALUE.",
                name);
            }
        }
        return hrefs;
    }
    
     public void getStatusCounts(RequestContext ctx, HandlerContext handlerCtx) {
        ObjectName[] instances = (ObjectName[])handlerCtx.getInputValue("instances");
        int running = 0;
        int restart = 0;
        int stopped = 0;
        
        if (instances != null) {
            for (int i = 0; i < instances.length; i++) {
                Object sts = null;
                try {
                    sts = MBeanUtil.invoke(instances[i], "getRuntimeStatus", null, null);
                } catch (Exception ex) {
                    // ignore
                }
                if (sts != null && sts instanceof RuntimeStatus) {
                    boolean restartNeeded = ((RuntimeStatus)sts).isRestartNeeded();
                    Status s = ((RuntimeStatus)sts).getStatus();
                    switch (s.getStatusCode()){
                        case Status.kInstanceStartingCode:
                        case Status.kInstanceRunningCode:
                            running++;
                            if (restartNeeded) 
                                restart++;
                            break;
                        case Status.kInstanceStoppingCode:
                        case Status.kInstanceNotRunningCode:
                            stopped++;
                            break;
                    }
                }
            }
        }
        handlerCtx.setOutputValue("running", new Integer(running));
        handlerCtx.setOutputValue("restart", new Integer(restart));
        handlerCtx.setOutputValue("stopped", new Integer(stopped));
    }   
        
    public static String getStatusIconHtml(ObjectName obj) {
        if (obj == null) 
            return "";
        Object sts = null;
        try {
            sts = MBeanUtil.invoke(obj, "getRuntimeStatus", null, null);
        } catch (Exception ex) {
            // ignore
        }
        return getStatusIconHtml(sts);
    }
    
    public static String getStatusHtml(Object sts) {
        if (sts == null) {
            return getStatusIconHtml(-1, false, null) + 
                Util.getMessage("serverinst.unknown");
        }
        else if (sts instanceof RuntimeStatus) {
            boolean restartNeeded = ((RuntimeStatus)sts).isRestartNeeded();
            Status s = ((RuntimeStatus)sts).getStatus();
            int statusCode = s.getStatusCode();
            String statusString = "";
            switch (statusCode) {
                case Status.kInstanceStartingCode:
                case Status.kInstanceRunningCode: {
                    if (restartNeeded) {
                        statusString = Util.getMessage("serverinst.restart");
                    } else {
                        statusString = Util.getMessage("serverinst.running");
                    }
                    break;
                }
                case Status.kInstanceStoppingCode:
                case Status.kInstanceNotRunningCode: {
                    statusString = Util.getMessage("serverinst.notRunning");
                    break;
                }
            }
            return getStatusIconHtml(statusCode, restartNeeded, null) + statusString;
        } else if (sts instanceof RuntimeStatusList) {
            RuntimeStatusList stsList = (RuntimeStatusList) sts;
            if (stsList.anyRunning())
                return getStatusIconHtml(Status.kInstanceRunningCode, false, stsList.toString()) + stsList.toString();
            else
                return getStatusIconHtml(Status.kInstanceNotRunningCode, false, stsList.toString()) + stsList.toString();
        }
        return "";
    }
    
    public static String getStatusIconHtml(Object sts) {
        if (sts == null) {
            return getStatusIconHtml(-1, false, null);
        }
        else if (sts instanceof RuntimeStatus) {
            boolean restartNeeded = ((RuntimeStatus)sts).isRestartNeeded();
            Status s = ((RuntimeStatus)sts).getStatus();
            int statusCode = s.getStatusCode();
            return getStatusIconHtml(statusCode, restartNeeded, null);
        }
        else if (sts instanceof RuntimeStatusList) {
            RuntimeStatusList stsList = (RuntimeStatusList) sts;
            if (stsList.anyRunning())
                return getStatusIconHtml(Status.kInstanceRunningCode, false, stsList.toString());
            else
                return getStatusIconHtml(Status.kInstanceNotRunningCode, false, stsList.toString());
        }
        return "<img src=\"" + blankGif + "\" border=\"0\" alt=\"\"/>&nbsp;";
        //return "<b>"+"?"+"</b>&nbsp;";
    }

    private static final String blankGif = 
        "/com_sun_web_ui/images/other/dot.gif\" width=\"11\" height=\"11";
    
    public static String getStatusIconHtml(int statusCode, boolean restartNeeded,
            String altMessage) {
        if (altMessage != null && altMessage.length() == 0) 
            altMessage = null;
        switch (statusCode) {
            case Status.kInstanceStartingCode:
            case Status.kInstanceRunningCode: {
                if (restartNeeded) {
		    String restartGif = Util.getMessage("serverinst.restartGif");
                    return "<img src=\"" + 
                        ((restartGif==null || restartGif.length()==0)?(blankGif):(restartGif)) + 
                        "\" border=\"0\" alt=\"" +
                        ((altMessage==null)?(Util.getMessage("serverinst.restart")):altMessage) +
                        "\" />&nbsp;";
                } else {
		    String runningGif = Util.getMessage("serverinst.runningGif");
                    return "<img src=\"" + 
                        ((runningGif==null || runningGif.length()==0)?(blankGif):(runningGif)) + 
                        "\" border=\"0\" alt=\"" +
                        ((altMessage==null)?Util.getMessage("serverinst.running"):altMessage) +
                        "\" />&nbsp;";
                }
            }
            case Status.kInstanceStoppingCode:
            case Status.kInstanceNotRunningCode: {
		String stoppedGif = Util.getMessage("serverinst.stoppedGif");
                return "<img src=\"" + 
                    ((stoppedGif==null || stoppedGif.length()==0)?(blankGif):(stoppedGif)) + 
                    "\" border=\"0\" alt=\"" +
                    ((altMessage==null)?Util.getMessage("serverinst.notRunning"):altMessage) +
                    "\" />&nbsp;";
            }
            case -1: {
		String unknownGif = Util.getMessage("serverinst.unknownGif");
                return "<img src=\"" + 
                    ((unknownGif==null || unknownGif.length()==0)?(blankGif):(unknownGif)) + 
                    "\" border=\"0\" alt=\"" +
                    ((altMessage==null)?Util.getMessage("serverinst.unknown"):altMessage) +
                    "\" />&nbsp;";
                
            }
            case Status.kEntityEnabledCode:
            case Status.kEntityDisabledCode:
            default:
                return "<img src=\"" + blankGif + "\" border=\"0\" alt=\"\"/>&nbsp;";
                //return "<b>"+"?"+"</b>&nbsp;";
        }
    }

    public void disableButtons(RequestContext ctx, HandlerContext handlerCtx) {

        Integer rCount = (Integer)handlerCtx.getInputValue("RunningCount");
        Integer sCount = (Integer)handlerCtx.getInputValue("StoppedCount");        
	if (rCount == null || sCount == null) 
	    throw new IllegalArgumentException(
		"The parameter map did not contain 'StatusCount'!");        
        int r = ((Integer)rCount).intValue(); 
        int s = ((Integer)sCount).intValue(); 
        
        if(r == 0) {
            handlerCtx.setOutputValue("runngingStatus", "true");
        } else {
            handlerCtx.setOutputValue("runngingStatus", "false");
        }
        if(s == 0) {
            handlerCtx.setOutputValue("stoppedStatus", "true");
        } else {
            handlerCtx.setOutputValue("stoppedStatus", "false");
        }        
    }
    

    public String formatStatusCount(RequestContext ctx, HandlerContext handlerCtx) {
        Object obj = handlerCtx.getInputValue("count");
        if (obj == null) 
            throw new RuntimeException("null count in formatStatusCount!");
        String count = obj.toString();
        if (count.trim().equals("0")) {
            if (blankGif == null || blankGif.length() == 0)
                return "&nbsp;&nbsp;--";
            else 
                return "<img src=\"" + blankGif + "\" border=\"0\" alt=\"\" />--";
        }
        
        String icon = (String)handlerCtx.getInputValue("icon");
        if (icon == null) 
            throw new RuntimeException("ICON is null in formatStatusCount!");
        String s = "";
        if (icon.equals("stopped"))
            s = getStatusIconHtml(Status.kInstanceStoppingCode, false, null) + "&nbsp;" +count;
        else if (icon.equals("restart"))
            s = getStatusIconHtml(Status.kInstanceRunningCode, true, null) + "&nbsp;" + count;
        else if (icon.equals("running"))
            s = getStatusIconHtml(Status.kInstanceRunningCode, false, null) + "&nbsp;" + count;
        return s; 
    }
        
    public String getObjectStatus(RequestContext ctx, HandlerContext handlerCtx) {
        Object sts = null;
        String objectName = (String) handlerCtx.getInputValue("objectName");

        // If the object is a node agent and if the rendezvous hasn't occured
        // yet, then need to give a better status than what the backend says.
        try {
            String objectType = new ObjectName(objectName).getKeyProperty("type");
            if (objectType.equals("node-agent")) {
                String[] types = new String[]{"java.lang.String"};
                Object[] params = new Object[]{"rendezvousOccurred"};
                String result = (String)MBeanUtil.invoke(
                    objectName, "getPropertyValue", params, types);
                if (result.equalsIgnoreCase("false")) {
                    String status = Util.getMessage("nodeAgent.awaitingInitialSync");
		    String stoppedGif = Util.getMessage("serverinst.stoppedGif");
                    if (stoppedGif != null && stoppedGif.length() != 0) {
                        status = "<img src=\"" + stoppedGif + 
                            "\" border=\"0\" alt=\"" + status + "\" />&nbsp;" +
                            status;
                    }
                    handlerCtx.setOutputValue("status", status);
                    return status;
               }
            }
        } catch (Exception ex) {
            // ignore
        }

        try {
            sts = MBeanUtil.invoke(objectName, "getRuntimeStatus", null, null);
        } catch (Exception ex) {
            // ignore
        }
        String status = getStatusHtml(sts);
        // strip off the icon if it's a placeholder for spacing.
        if (status.indexOf("dot.gif") > 0) {
            int i = status.indexOf(";"); // from nbsp;
            if (i > 0)
                status = status.substring(i+1);
        }
        handlerCtx.setOutputValue("status", status);
        return status;
    }
    
    public String isRunning(RequestContext ctx, HandlerContext handlerCtx) {
        String status = "false";
        String objectName = (String) handlerCtx.getInputValue("objectName");
        try {
            Object sts = MBeanUtil.invoke(objectName, "getRuntimeStatus", null, null);
            if (sts != null && sts instanceof RuntimeStatus) {
                Status s = ((RuntimeStatus)sts).getStatus();
                int statusCode = s.getStatusCode();
                switch (statusCode) {
                    case Status.kInstanceStartingCode:
                    case Status.kInstanceRunningCode: 
                        status = "true";
                        break;
                    default:
                        status = "false";
                        break;
                }
            }
        } catch (Exception ex) {
            // ignore
        }
        handlerCtx.setOutputValue("status", status);
        return status;
    }
    
    public String getClusterStatus(RequestContext ctx, HandlerContext handlerCtx) {
        int restart = 0;
        int running = 0;
        int stopped = 0;
        int unknown = 0;
    
        String status = Util.getMessage("serverinst.noInstances"); // "No Server Instances Defined";
        String clusterObjectName = (String) handlerCtx.getInputValue("clusterObjectName");
        Object objs = MBeanUtil.invoke(clusterObjectName, "listServerInstances", null, null);
        if (objs != null && objs instanceof ObjectName[]) {
            ObjectName [] instances = (ObjectName [])objs;
            for (int i=0; i<instances.length; i++) {
                Object sts = null;
                try {
                    sts = MBeanUtil.invoke(instances[i], "getRuntimeStatus", null, null);
                } catch (Exception ex) {
                    // ignore
                }
                if (sts != null && sts instanceof RuntimeStatus) {
                    boolean restartNeeded = ((RuntimeStatus)sts).isRestartNeeded();
                    Status s = ((RuntimeStatus)sts).getStatus();
                    int statusCode = s.getStatusCode();
                    switch (statusCode) {
                        case Status.kInstanceStartingCode:
                        case Status.kInstanceRunningCode:
                            running++;
                            if (restartNeeded) 
                                restart++;
                            break;
                        case Status.kInstanceStoppingCode:
                        case Status.kInstanceNotRunningCode:
                            stopped++;
                            break;
                    }
                } else {
                    unknown ++;
                }
            }
            if (instances.length > 0) {
                status = "" + running + Util.getMessage("serverinst.runningInstances");
                if (stopped > 0)
                    status += "<br />" + stopped + Util.getMessage("serverinst.stoppedInstances");
                if (restart > 0)
                    status += "<br />" + restart + Util.getMessage("serverinst.restartInstances");
                if (unknown > 0)
                    status += "<br />" + unknown + Util.getMessage("serverinst.unknown");
            }          
        }
        handlerCtx.setOutputValue("status", status);
        return status;
    }

    public boolean isTargetSupported(RequestContext ctx, HandlerContext handlerCtx) {
        Boolean isTargetSupported = 
            ConfigProperties.getInstance().getTargetSupported();
        handlerCtx.setOutputValue("isTargetSupported", isTargetSupported);
        return isTargetSupported.booleanValue();
    }
    
    public String endDisplayInstanceStatus(RequestContext ctx, HandlerContext handlerCtx) {
        ObjectName[] instances = (ObjectName[])handlerCtx.getInputValue("instances");
        String method = (String) handlerCtx.getInputValue("methodName");
        
        String result = "";
        if (instances != null) {
            for (int i = 0; i < instances.length; i++) {
                if (i > 0) {
                    result = result + "<br />";
                }
                Object value = MBeanUtil.invoke(instances[i], method, null, null);
                if (value != null) {
                    if (value instanceof RuntimeStatus)
                        result += ((RuntimeStatus)value).toShortString().replaceAll(" ", "&nbsp;");
                    else
                        result += value.toString().replaceAll(" ", "&nbsp;");
                }
            }
        }
        return result;
    }
    
    public void resourceRefAction(RequestContext ctx, HandlerContext handlerCtx) {
    	View view = handlerCtx.getView();
    	DescriptorContainerView descView = (DescriptorContainerView)
    	    (((ViewBase)view).getParentViewBean());
    	ViewDescriptor vd = descView.getViewDescriptor();
    	//we may need to get the tabilChildName from the xml file.
        String tableChildName = (String)handlerCtx.getInputValue("tableChildName");
    	ViewDescriptor tableDescriptor = vd.getChildDescriptor(tableChildName);
    	if (tableDescriptor == null) {
    	    throw new FrameworkException("tableDescriptor is null", vd, view);
    	}
    	if (!(tableDescriptor instanceof CCActionTableDescriptor)) {
    	    throw new FrameworkException("tableDescriptor is of wrong type",
    		tableDescriptor, view);
    	}
    	CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("propertiesModel");
    	if (model == null) {
                throw new FrameworkException("PropertiesHandler.getModel: Parameter 'propertiesModel' not specified");
            }
        String editKeyValue = (String)handlerCtx.getInputValue("editKeyValue");
    	String action = (String)handlerCtx.getInputValue("action");
    	String methodName = (String)handlerCtx.getInputValue("methodName");
    	//CCActionTableModelInterface model = ((CCActionTableDescriptor)tableDescriptor).getModel();
    	
    	model.setRowSelectionType("multiple");
    	try {
    	    model.beforeFirst();
    	    while(model.next()) {
    		if (model.isRowSelected()) {
    		    String objectName = (String)model.getValue("objectName");
    		    ObjectName resRefObjectName = (ObjectName)MBeanUtil.invoke(objectName,
    				methodName, new Object[]{editKeyValue}, new String[]{"java.lang.String"});
    		    changeEnableStatus(resRefObjectName, action);
    		    model.setRowSelected(false);
    		}
    	    }
    	} catch (Exception ex) {
    	    throw new FrameworkException("Error while enabling: '"+
    		vd.getName()+"'", ex, vd, null);
        }
    	ContainerViewBase containerView = 
                (ContainerViewBase)(tableDescriptor.getView(ctx).getParent());
    	containerView.removeChild(tableDescriptor.getName());
    	((DefaultModel)model).clear();
    }
    
    public static void changeEnableStatus(ObjectName resRefObjectName, String action){
        Attribute attr = new Attribute("enabled", action);
        MBeanUtil.setAttribute(resRefObjectName, attr);
        if(action.equals("true")){
            //we need to ensure the resource itself is enabled.
            String editKeyValue = resRefObjectName.getKeyProperty("ref");
            changeResourceAttribute(editKeyValue, attr);
        }
    }
    
    static private void changeResourceAttribute(String resName, Attribute attr){
        try{
            String resType = (String) MBeanUtil.invoke(
                    "com.sun.com.sun.appserv:type=resources,category=config",
                    "getResourceType",
                    new String[] {resName},
                    new String[] {"java.lang.String"}); 
            ObjectName obj = new ObjectName("com.sun.com.sun.appserv:category=config,type="+resType+",jndi-name="+resName);
            MBeanUtil.setAttribute(obj, attr);
        }catch(javax.management.MalformedObjectNameException ex){
            throw new FrameworkException("error in TargetHandlers changeEnableStatus :", ex);
        }
    }
    
    public void changeResourceStatusAll(RequestContext ctx, HandlerContext handlerCtx) {
	View view = handlerCtx.getView();
	DescriptorContainerView descView = (DescriptorContainerView)
	    (((ViewBase)view).getParentViewBean());
	ViewDescriptor vd = descView.getViewDescriptor();
	String childName = (String)vd.getParameter("tableChildName");

	if (childName == null) {
	    throw new FrameworkException("childName not specified", vd, view);
	}
	ViewDescriptor tableDescriptor = vd.getChildDescriptor(childName);
	if (tableDescriptor == null) {
	    throw new FrameworkException("tableDescriptor is null", vd, view);
	}
	if (!(tableDescriptor instanceof CCActionTableDescriptor)) {
	    throw new FrameworkException("tableDescriptor is of wrong type",
		tableDescriptor, view);
	}
        String newStatus = (String)handlerCtx.getInputValue("new-status");
        String key = (String)handlerCtx.getInputValue("key");
        doAction(((CCActionTableDescriptor)tableDescriptor).getModel(), tableDescriptor, key, newStatus);
    }

    static private void doAction(CCActionTableModelInterface model, ViewDescriptor vd, String key, String newStatus) {
	RequestContext ctx = RequestManager.getRequestContext();
        Attribute attr = new Attribute("enabled", newStatus);
        try{
            model.setRowSelectionType("multiple");
            model.beforeFirst();
            // from the model, get the child that has the needed value...
            while(model.next()) {
                if (model.isRowSelected()) {
                    String resName = (String) model.getValue(key);
                    //we never disable the resource itself.
                    if (newStatus.equals("true")){
                        MBeanUtil.setAttribute((String)model.getValue("objectName"), attr);
                        //changeResourceAttribute(resName, attr);
                    }
                    String[] params = new String[] {resName};
                    String[] types = new String[] {"java.lang.String"};
                    boolean isTargetSupported = ConfigProperties.getInstance().getTargetSupported().booleanValue();
                    if (!isTargetSupported){
                        MBeanUtil.setAttribute("com.sun.appserv:type=resource-ref,server=server,category=config,ref="+resName, attr);
                    }else{
                        ObjectName[] targets = (ObjectName[]) MBeanUtil.invoke("com.sun.appserv:type=resources,category=config" , "listReferencees", params, types); 
                        if (targets == null)
                            continue;
                        for(int i=0; i<targets.length; i++){
                            ObjectName resRef = (ObjectName)MBeanUtil.invoke(targets[i], "getResourceRefByRef", params, types); 
                            MBeanUtil.setAttribute(resRef, attr);
                        }
                    }
                    model.setRowSelected(false);
                }
            }
        }catch (Exception ex){
            throw new FrameworkException("error in changeResourceStatus ", ex);
        }
	View view = vd.getView(ctx).getParent();
	ContainerViewBase descView = (ContainerViewBase)view;
	descView.removeChild(vd.getName());
	((DefaultModel)model).clear();
    }
    
    //=======================
    
    public void getDefaultTarget(RequestContext ctx, HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("defaultTarget", 
            ConfigProperties.getInstance().getDefaultTarget());
    }
    
    public void beginResourceEditTabsDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        HREF href = (HREF)handlerCtx.getView();
        href.setValue(href.getValue() + ".RESOURCENAME.");
    }
    
    public String endResourceEditTabsDisplay(RequestContext ctx, HandlerContext handlerCtx) {
	if (!(handlerCtx.getEvent() instanceof ChildContentDisplayEvent)) {
	    return null;
	}
	ChildContentDisplayEvent dispEvent = (ChildContentDisplayEvent)handlerCtx.getEvent();
	String content = dispEvent.getContent();
        content = content.replaceAll(".RESOURCENAME.", 
            "&name="+ctx.getRequest().getAttribute("editKeyValue"));
        return content;
    }
    
    public void beginEditTabsDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        HREF href = (HREF)handlerCtx.getView();
        href.setValue(href.getValue() + ".PLACEHOLDER.");
    }
    
    public String endEditTabsDisplay(RequestContext ctx, HandlerContext handlerCtx) {
	if (!(handlerCtx.getEvent() instanceof ChildContentDisplayEvent)) {
	    return null;
	}
	ChildContentDisplayEvent dispEvent = (ChildContentDisplayEvent)handlerCtx.getEvent();
	String content = dispEvent.getContent();
        String key = (String)handlerCtx.getInputValue("key");
        if (key==null)
            key="name";
        content = content.replaceAll(".PLACEHOLDER.", 
            "&"+ key + "=" + ctx.getRequest().getAttribute(key));
        return content;
    }
    
    public String endClusteredInstanceTabsDisplay(RequestContext ctx, HandlerContext handlerCtx) {
	if (!(handlerCtx.getEvent() instanceof ChildContentDisplayEvent)) {
	    return null;
	}
	ChildContentDisplayEvent dispEvent = (ChildContentDisplayEvent)handlerCtx.getEvent();
	String content = dispEvent.getContent();
        String key = (String)handlerCtx.getInputValue("key");
        if (key==null)
            key="name";
        content = content.replaceAll(".PLACEHOLDER.", 
            "&"+ key + "=" + ctx.getRequest().getAttribute(key) + "&isCluster=true");
        return content;
    }
}
