/*
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 * Use is subject to license terms.
 */

package com.sun.enterprise.tools.admingui.servlet;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.security.NoSuchAlgorithmException;
import java.security.KeyManagementException;

import com.sun.enterprise.tools.admingui.util.JSSE;

public final class HelpWindowFilter implements Filter {

      private FilterConfig filterConfig = null;

      public void init(FilterConfig filterConfig) throws ServletException {
          this.filterConfig = filterConfig;
      }
    
      public void destroy() {
          this.filterConfig = null;
      }
      public void doFilter(ServletRequest request, ServletResponse response,
                               FilterChain chain) throws IOException, ServletException {

      if (filterConfig == null) {
          return;
	}
      if(!request.isSecure()) {
	chain.doFilter(request, response);
	return;
      }
	try {
		JSSE.trustAnyServerCertificate();
	}
	catch(KeyManagementException ex) {
		//Ignore
		ex.printStackTrace();
	}
	catch(NoSuchAlgorithmException ex) {
		//Ignore
		ex.printStackTrace();
	}

      chain.doFilter(request, response);
    }

}

