/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.admingui.tree;

import java.io.*;
import java.lang.reflect.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import javax.management.ObjectName;

import com.iplanet.jato.*;
import com.iplanet.jato.model.*;
import com.iplanet.jato.util.*;
import com.iplanet.jato.view.*;
import com.iplanet.jato.view.event.*;
import com.iplanet.jato.view.html.*;

import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.handlers.TargetHandlers;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;


public class IndexTreeView extends RequestHandlingTreeViewBase {
    public static final String CHILD_NAME               = "name";
    public static final String CHILD_SHOW_ROOT          = "root";
    public static final String CHILD_SHOW_LEAF          = "showLeaf";
    public static final String CHILD_SHOW_CONTAINER     = "showContainer";
    
    public static final String CHILD_SHOW_ROOT_I        = "Iroot";
    public static final String CHILD_SHOW_LEAF_I        = "IshowLeaf";
    public static final String CHILD_SHOW_CONTANER_I    = "IshowContainer";
    
    public static final String CHILD_HANDLE_IMAGE       = "Handle";

    private NewTagsText newTags = null;

    public IndexTreeView(View parent, String name) {
	super(parent, name, //"IndexTreeStateData");
            Util.getCurrentTreeModel().getStateDataName());
	
	setPrimaryModel(Util.getCurrentTreeModel());
	registerChildren();
    }
    
    protected IndexTreeModel getIndexTreeModel() {
	return (IndexTreeModel)getPrimaryModel();
    }
    
    protected void registerChildren() {
	registerChild(CHILD_NAME,           StaticTextField.class);
	registerChild(CHILD_SHOW_ROOT,      HREF.class);
	registerChild(CHILD_SHOW_LEAF,      HREF.class);
	registerChild(CHILD_SHOW_CONTAINER, HREF.class);
	
	registerChild(CHILD_SHOW_ROOT_I,    ImageField.class);
	registerChild(CHILD_SHOW_LEAF_I,    ImageField.class);
	registerChild(CHILD_SHOW_CONTANER_I,ImageField.class);
	registerChild(CHILD_HANDLE_IMAGE,   ImageField.class);
    }
    
    protected View createChild(String name) {
	if (name.equals(CHILD_NAME)) {
	    StaticTextField child = new StaticTextField(this, getIndexTreeModel(), CHILD_NAME,
	    IndexTreeModel.FIELD_NAME, "", null);
	    return child;
	}
	else if (name.equals(CHILD_SHOW_ROOT) ||
                name.equals(CHILD_SHOW_LEAF) ||
                name.equals(CHILD_SHOW_CONTAINER)) {
	    return new HREF(this, name,  null);
	}
	else if (name.equals(CHILD_SHOW_ROOT_I) || 
                name.equals(CHILD_HANDLE_IMAGE) ||
                name.equals(CHILD_SHOW_LEAF_I) ||
                name.equals(CHILD_SHOW_CONTANER_I)) {
	    return new ImageField(this, name, null);
	}
	else
	    return null;
    }
    
    private static Object osync = new Object();	// Synchronizer object
    
    // an inner class to handle tag reformatting to support node highlighting in the tree.
    class NewTagsText {
        public final String beginTD1 = "<td align=\"left\" valign=\"center\" width=\"24\" nowrap=\"nowrap\">";
        public final String beginTD2 = "<td align=\"left\" valign=\"center\" nowrap=\"nowrap\">";
        public final String endTD = "</td>\n";
        public final String restartImg = "<img src=\"../images/restartServer.gif\" alt=\"restart\" border=\"0\"/>";
        public final String hrefExtras = "title=\"@@@@\" " +
            "onmouseover=\"window.status='@@@@'; return true\" " +
            "onmouseout=\"window.status=''; return true\" " +
            "onkeypress=\"javascript: this.onClick();\" " +
            "onblur=\"window.status=''; return true\" " +
            "onfocus=\"window.status='@@@@'; return true\" ";

	private String imgTag;
	private String hrefTag;
        private Stack sibs;
        public boolean rootNode;
	
	public NewTagsText() {            
	    reset();
	}
	private void reset() {
	    imgTag = null;
	    hrefTag = null;
            sibs = null;
            rootNode = false;
	}
        public boolean hasNextSibling() {
            if (sibs == null) {
                synchronized (osync) {
                    // add a synchronize here to protect the value of the current 
                    // node tin the model. getNextSibling() changes the current 
                    // node. 
                    sibs = new Stack();
                    IndexTreeModel model = (IndexTreeModel)getPrimaryModel();
                    IndexTreeNode node = (IndexTreeNode)(model.getCurrentNode());
                    int level = ((IndexTreeModel)getPrimaryModel()).getNodeLevel();
                    //System.out.println("NEW STACK: level="+level);
                    while (node != null) {
                        //System.out.print("    Parent Node: "+node.getName()+"  "+node);
                        if (level > 1 && node.getParent() == null) {
                            // jato is doing weird stuff, don't do the root node 
                            // unless it's a child of the root.
                            break; 
                        }
                        Boolean bool = new Boolean(node.getNextSibling() != null);
                        //System.out.print("    Pushing: "+bool.booleanValue());

                        // Push twice because the JSP calls twice, the posittive and
                        // negative versions of the content tags.
                        sibs.push(bool);
                        sibs.push(bool);
                        node = node.getParent();
                    }
                }
            }
            if (sibs.empty()) {
                //throw new FrameworkException(
                if (Util.isLoggableFINE()) {
                    Util.logFINE("IndexTreeView.hasNextSibling: Next Sibling Stack is Empty!", null);
                }
                return false;
            }
            Boolean answer = (Boolean)sibs.pop();
            return answer.booleanValue();
        }
	public void setImgTag(String s) {
	    imgTag = s;
	}
	public void setHrefTag(String s) {
	    hrefTag = s;
	}
	private String addHref(String text, String hrefTag) {
	    if (hrefTag == null)
		return text;
	    int i = hrefTag.indexOf('>');
	    if (i<0)
		return text;
	    return hrefTag.substring(0, i+1)+"\n"+text+"</a>";
	}
 
	public String toString() {
	    // get the Highlight ID for the current node being processed.
	    String id = ((IndexTreeModel)getPrimaryModel()).getNodeHID();
	    boolean expanded = getStateData().isNodeExpanded(getPrimaryModel().getNodeID());
	    String icon = ((IndexTreeModel)getPrimaryModel()).getIconName(expanded);
	    
	    IndexTreeNode node = ((IndexTreeNode)((IndexTreeModel)getPrimaryModel()).getCurrentNode());
            
	    // sanity checks.... shouldn't return from here
	    if (imgTag == null && hrefTag == null)
		return "";
	    if (imgTag != null && hrefTag == null)
		return imgTag;
	    if (imgTag == null && hrefTag != null)
		return hrefTag;
	    
            // may want to show a status icon?
            String status = "";
            String showStatus = (String) node.getAttribute("showStatus", false);
            try {
            if (showStatus != null && showStatus.equalsIgnoreCase("true")) {
                String objName = (String) node.getAttribute("objectName", false);
                status = "&nbsp;"+TargetHandlers.getStatusIconHtml(new ObjectName(objName));
            }
            } catch (Exception ex) {
                // ignore
            }

            // modify the JavaScript by replacing the "this" parameter with the highlight node ID
	    hrefTag = hrefTag.replaceAll("this", id);
            
            // check for a special display name for the node.
            String displayName = (String)
                node.getAttribute(IndexTreeModel.FIELD_DISPLAYNAME, false);
            if (displayName == null) {
                displayName = node.getName();
            } 
            
            // special case labeling of the admin server instance & config
            String adminServerName = (String) node.getAttribute("adminServerName", false);
            if (adminServerName != null && displayName.equalsIgnoreCase(adminServerName)) {
                displayName += " (" + Util.getMessage("tree.adminServer") + ")";
                String asIcon = Util.getMessage("tree.adminServerImage"); //"adminserver.gif";
                if (asIcon != null && asIcon.length() > 0)
                    icon = asIcon;
            }
            String adminServerConfigName = (String) node.getAttribute("adminServerConfigName", false);
            if (adminServerConfigName != null && displayName.equalsIgnoreCase("server-config")) {
                displayName += " (" + Util.getMessage("tree.adminServerConfig") + ")";
                String asIcon = Util.getMessage("tree.adminServerConfigImage");
                if (asIcon != null && asIcon.length() > 0)
                    icon = asIcon;
            }
            if (displayName.equals(node.getName()) == false) { // replace the name in the a-tag
                hrefTag = addHref(displayName, hrefTag);
            }
            
            hrefTag = Util.addHtmlProp(hrefTag, hrefExtras.replaceAll("@@@@", displayName));
            String hrefImageTag = hrefTag;
	    
	    // change the name attribute of the img tag
	    String newImgTag = Util.addHtmlProp(Util.removeHtmlProp(imgTag, "name"), ("name=\"i" + id + "\"")); // for ns4
            if (rootNode) {
                Object obj = RequestManager.getRequestContext()
                            .getRequest().getAttribute("restartRequired");
                boolean replaceIcon = false;
                if (obj != null) {
                    if (obj instanceof Boolean) {
                        replaceIcon = ((Boolean)obj).booleanValue();
                    } else if (obj instanceof String) {
                        replaceIcon = "true".equalsIgnoreCase((String)obj);
                    }
                }
                if (replaceIcon) {
                    String rrIcon = Util.getMessage("icon.InstanceRestartRequired");
                    if (rrIcon != null && rrIcon.equals("")==false)
                        icon = rrIcon;

                    String rrText = Util.getMessage("masthead.restartRequired");
                    hrefImageTag = Util.addHtmlProp(Util.removeHtmlProp(hrefTag, "title"), ("title=\"" + rrText + "\""));
                    hrefImageTag = Util.addHtmlProp(Util.removeHtmlProp(hrefImageTag, "href"), ("href=\"../admingui/restart\""));
                }
            } 
            newImgTag = Util.addHtmlProp(Util.removeHtmlProp(newImgTag, "src"), "src=\"../images/"+icon+"\"");
            
	    // build the new tags, first surround the img tab in an a-tag.
            String newTag = beginTD1 + addHref(newImgTag, hrefImageTag) + endTD;

            // add an ID attribute to the TD-tag and add the href tag
	    newTag +=  beginTD2 + Util.addHtmlProp(hrefTag, "id=\"a"+id+"\"") + status + endTD;
	    
	    reset(); // be ready to start again.
	    return newTag.trim();
	}
    }
    
    public TreeViewStateData getStateData() {
        // override JATO function to make sure the correct state data is being used.
        String dataName = Util.getCurrentTreeModel().getStateDataName();
        if (getStateDataLookupName().equals(dataName) == false) {
            setStateDataLookupName(dataName);
            TreeViewStateData data = (TreeViewStateData)
                getRequestContext().getRequest().getSession().getAttribute(dataName);

            if (data == null)
                data = new SimpleTreeViewStateData(new HashMap());

            super.setStateData(data);
        }
        return super.getStateData();
    }
    
    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        IndexTreeModel model = Util.getCurrentTreeModel();
	setPrimaryModel(model);

	// Ensure the primary model is non-null; if null, it would cause
	// havoc with the various methods dependent on the primary model
	if (getPrimaryModel()==null)
	    throw new ModelControlException("Primary model is null");
	
	super.beginDisplay(event);
	
	model.beforeRoot();
	// move the root node and open it.
	model.nextNode();
	getStateData().setNodeExpanded(model.getNodeID(), true);
        
        IndexTreeNode root = model.getRoot();
        String count = (String)root.getAttribute("kidsToOpen");
        if (count != null) {
            int max = new Integer(count).intValue();
            root.setAttribute("kidsToOpen", null);
            Iterator it = root.getChildren().iterator();
            int i = 0;
            // open the first two top level nodes for PE only.
            while (it.hasNext()) {
                if (i >= max) break;
                getStateData().setNodeExpanded(((IndexTreeNode)it.next()).getPath(), true);
                i++;
            }	
        }
	newTags = new NewTagsText();
    }
    
    // The next set of methods come in pairs. The image tag is first and is
    // saved. It is then written with the a-tag, which should immediately follow.
    public String endIrootDisplay(ChildContentDisplayEvent event) {
	String content = event.getContent();
	newTags.setImgTag(content);
	return "";
    }
    public String endRootDisplay(ChildContentDisplayEvent event) {
	String content = event.getContent();
	newTags.setHrefTag(content);
        newTags.rootNode = true;
	String newContent = newTags.toString();
	return newContent;
    }
    public String endIshowLeafDisplay(ChildContentDisplayEvent event) {
	String content = event.getContent();
	newTags.setImgTag(content);
	return "";
    }
    public String endShowLeafDisplay(ChildContentDisplayEvent event) {
	String content = event.getContent();
	newTags.setHrefTag(content);
	String newContent = newTags.toString();
	return newContent;
    }
    public String endIshowContainerDisplay(ChildContentDisplayEvent event) {
	String content = event.getContent();
	newTags.setImgTag(content);
	return "";
    }
    public String endShowContainerDisplay(ChildContentDisplayEvent event) {
	String content = event.getContent();
	newTags.setHrefTag(content);
	String newContent = newTags.toString();
	return newContent;
    }
    
    // Only used for debugging; an easy way to show the ID on the page.
    public String endGetIdDisplay(ChildContentDisplayEvent event) {
	String id = ((IndexTreeModel)getPrimaryModel()).getNodeHID();
	return id;
    }
    
    public String endTableRowDisplay(ChildContentDisplayEvent event) {
        String tr = "<tr ";
	IndexTreeNode node = ((IndexTreeNode)((IndexTreeModel)getPrimaryModel()).getCurrentNode());
        
        if (node.getType().equalsIgnoreCase(IndexTreeModel.ROOT)) {
            String rootClass = (String) node.getAttribute("rootClass");
            if (rootClass == null)
                rootClass = "TreRotRow"; // or "treTbl"
            // The root nodes need a different bg color and hieght must be 30px
            // The letter before the id telling javascript how to highlight.
            tr += "height=\"30\" class=\""+rootClass+"\" id=\"r" + node.getHighlightID() + "\">";
        } else  {
            tr += "id=\"c" + node.getHighlightID() + "\">";
        }
        return tr;
    }
    
    // This wraps the content between the <td> </td> tags
    // This is needed because the must not be a newline before the </td>
    // or the table cell will be the wrong size. 
    public String endAddTdDisplay(ChildContentDisplayEvent event) {
	String content = event.getContent();
        return newTags.beginTD2 + content.trim() + newTags.endTD;
    }
    
    
    public boolean beginHasNextSiblingDisplay(ChildDisplayEvent event) {
        return newTags.hasNextSibling();
    }
    public boolean beginHasNoNextSiblingDisplay(ChildDisplayEvent event) {
	return (newTags.hasNextSibling() == false);
    }

    public boolean beginHasContainerKidsDisplay(ChildDisplayEvent event) {
	IndexTreeNode node = getIndexTreeModel().getNode(getPrimaryModel().getNodeID());
	return node.getChildren().size() > 0;
    }
    public boolean beginHasNoContainerKidsDisplay(ChildDisplayEvent event) {
	return ! beginHasContainerKidsDisplay(event);
    }
    
    public boolean beginShowContainerDisplay(ChildDisplayEvent event) {
	HREF href=(HREF)getDisplayField(CHILD_SHOW_CONTAINER);
	href.setValue(getIndexTreeModel().getValue(IndexTreeModel.FIELD_ID));
	
	IndexTreeNode node = getIndexTreeModel().getNode(getPrimaryModel().getNodeID());
	node.setIsExpanded(getStateData().isNodeExpanded(getPrimaryModel().getNodeID()));
	return true;
    }
    
    public boolean beginRootDisplay(ChildDisplayEvent event) {
	HREF href=(HREF)getDisplayField(CHILD_SHOW_ROOT);
	href.setValue(getIndexTreeModel().getValue(IndexTreeModel.FIELD_ID));
	
	IndexTreeNode node = getIndexTreeModel().getNode(getPrimaryModel().getNodeID());
	node.setIsExpanded(getStateData().isNodeExpanded(getPrimaryModel().getNodeID()));
	return true;
    }
    
    public boolean beginShowLeafDisplay(ChildDisplayEvent event) {
	// We do this here so that the field can remain bound to the default model
	HREF href=(HREF)getDisplayField(CHILD_SHOW_LEAF);
	href.setValue(getIndexTreeModel().getValue(IndexTreeModel.FIELD_ID));
	
	IndexTreeNode node = getIndexTreeModel().getNode(getPrimaryModel().getNodeID());
	node.setIsExpanded(getStateData().isNodeExpanded(getPrimaryModel().getNodeID()));
	return true;
    }
    
    private void handleNode(String nodeID, RequestInvocationEvent event)
    throws ModelControlException, ClassNotFoundException, ServletException, IOException, NodeNotFoundException {
	IndexTreeNode selectedNode = getIndexTreeModel().getNode(nodeID);
	selectedNode.handleSelection(getRequestContext());
    }
    
    public void handleShowLeafRequest(RequestInvocationEvent event)
    throws ModelControlException, ClassNotFoundException, ServletException, IOException, NodeNotFoundException {
	handleNode((String)getDisplayFieldValue(CHILD_SHOW_LEAF), event);
    }
    
    public void handleRootRequest(RequestInvocationEvent event)
    throws ModelControlException, ClassNotFoundException, ServletException, IOException, NodeNotFoundException {
	handleNode((String)getDisplayFieldValue(CHILD_SHOW_ROOT), event);
    }
    
    public void handleShowContainerRequest(RequestInvocationEvent event)
    throws ModelControlException, ClassNotFoundException, ServletException, IOException, NodeNotFoundException {
	handleNode((String)getDisplayFieldValue(CHILD_SHOW_CONTAINER), event);
    }
}
