/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.event.handlers;

import com.iplanet.jato.RequestContext;

import com.sun.enterprise.tools.guiframework.view.HandlerContext;

import java.util.Map;


/**
 *
 */
public class RequestParameterHandlers {

    /**
     *	<p> This method retrieves the request parameter by the given key.  If
     *	    the request parameter does not exist, null will be returned.  It
     *	    requires a parameter named KEY be passed in via the parameter
     *	    Map.</p>
     *
     *	@param	reqCtx		The RequestContext
     *	@param	handlerCtx	The HandlerContext
     *
     *	
     */
    public void getRequestParameter(RequestContext reqCtx, HandlerContext handlerCtx) {
    	Object key = handlerCtx.getInputValue(KEY);
	if (key == null) {
	    throw new IllegalArgumentException(
		"The parameter map did not contain a key!");
	}
	handlerCtx.setOutputValue(
	    VALUE, reqCtx.getRequest().getParameter(key.toString()));
    }


    /**
     *	<p> This method retrieves the request parameter by the given key.  If
     *	    the request parameter does not exist, null will be returned. It
     *	    requires a parameter named KEY to be passed in via the
     *	    parameter Map.</p>
     *
     *	@param	reqCtx		The RequestContext
     *	@param	handlerCtx	The HandlerContext
     */
    public void getRequestParameters(RequestContext reqCtx, HandlerContext handlerCtx) {
    	Object key = handlerCtx.getInputValue(KEY);
	if (key == null) {
	    throw new IllegalArgumentException(
		"The parameter map did not contain a key!");
	}
	handlerCtx.setOutputValue(
	    VALUE, reqCtx.getRequest().getParameterValues(key.toString()));
    }


    /**
     *
     */
    public static final String VALUE	= "value";

    /**
     *
     */
    public static final String KEY	= "key";
}
