/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view;

import com.iplanet.jato.NavigationException;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;

import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import java.util.Map;


/**
 *  Interface defining a DescriptorView.
 *
 *  <P>NOTE: Top-level display items (ViewBean's) should also implement
 *	com.iplanet.jato.command.Command</P>
 */
public interface DescriptorContainerView extends ContainerView {
    /**
     *	This method retrieves this View ViewDescriptor.
     *
     *	@return This View's ViewDescriptor.
     */
    public ViewDescriptor getViewDescriptor();



    //////////////////////////////////////////////////////////////////////
    //              Child Registration / Creation Methods               //
    //////////////////////////////////////////////////////////////////////

    /**
     *	<P>This method is defined in ContainerView, but it is important to
     *	to override this.</P>
     *
     *	<P>This method should delegate to the helper createChild method to use
     *	the descriptor information.</P>
     *
     *	<P>For example:</P>
     *	<P>&nbsp;</P>
     *	<CODE>return DescriptorViewHelper.createChild(this, name);</CODE>
     *	<P>&nbsp;</P>
     */
    public View createChild(String name);


    /**
     *
     */
    public RequestContext getRequestContext();


    /**
     *
     */
    public void setRequestContext(RequestContext context);


    /**
     *	Make forwarding easy
     */
    public void forwardTo(RequestContext requestContext) throws NavigationException;



    //////////////////////////////////////////////////////////////////////
    //                          Event Methods                           //
    //////////////////////////////////////////////////////////////////////

    /**
     *	This method dispatches BeginDisplay events to each registered
     *	BeginDisplay event handler according the the ViewDescriptor.
     *	This method is defined in ContainerView, but it is important to
     *	to override this.
     *
     *	@param event	The DisplayEvent, created internally by JATO
     */
    public void beginDisplay(DisplayEvent event) throws ModelControlException;


    /**
     *	This method is defined in ContainerView, but it is important to 
     *	override this.
     */
    public boolean beginChildDisplay(com.iplanet.jato.view.event.ChildDisplayEvent event) throws ModelControlException;


    /**
     *	This method is defined in ContainerView, but it is important to 
     *	override this.
     */
    public String endChildDisplay(com.iplanet.jato.view.event.ChildContentDisplayEvent event) throws ModelControlException;


    /**
     *	This method is defined in ContainerView, but it is important to 
     *	override this.
     */
    public void endDisplay(DisplayEvent event);


    /**
     *	<P>Children need to be registered so that values can be submitted back
     *	to DisplayFields, CommandFields can be handled, and containers which
     *	contain these things will work.  So... to ensure that
     *	DescriptorContainerView's work, the following
     *	registerViewDescriptorChildren() method must be implemented.  This
     *	method is named this way to avoid accidentally overriding a
     *	registerChildren method.  Since JATO did not make this part of an
     *	interface, we cannot do super.registerChildren(). <B>This method should
     *	be invoked from the constructor after the ViewDescriptor has been
     *	set.</B>  Most implementations of this method should do the
     *	following:</P>
     *
     *	<BLOCKQUOTE><CODE>
     *	    DescriptorViewHelper.registerViewDescriptorChildren(getViewDescriptor(), this);
     *	</CODE></BLOCKQUOTE>
     *
     */
    public void registerViewDescriptorChildren();
}
