/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view;

import com.iplanet.jato.view.View;

import com.sun.enterprise.tools.guiframework.event.descriptors.HandlerDescriptor;
import com.sun.enterprise.tools.guiframework.event.descriptors.UseHandlerDescriptor;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;

import java.util.EventObject;


/**
 *
 */
public interface HandlerContext {

    /**
     *	This returns the nearest View associated with the handler.
     */
    public View getView();


    /**
     *	This method returns the nearest ViewDescriptor associated with the
     *	handler.
     */
    public ViewDescriptor getViewDescriptor();


    /**
     *	This method returns the Event that caused the handler to be invoked.
     */
    public EventObject getEvent();


    /**
     *	This method returns the UseHandlerDescriptor associated with the
     *	handler.  The UseHandlerDescriptor can be thought of the instance
     *	of the handler that is being invoked.  It contains the actual input
     *	parameters to sent to the handler (if any), and a reference to the
     *	handler definition (HandlerDescriptor).
     */
    public UseHandlerDescriptor getUseHandlerDescriptor();


    /**
     *	This method returns the HandlerDescriptor associated with the handler.
     *	The handler descriptor can be thought of the definition to the handler
     *	itself.  It contains the method, I/O definition, and may also define
     *	other UseHandlers to be invoked prior to executing itself.
     */
    public HandlerDescriptor getHandlerDescriptor();


    /**
     *	This method returns the input value for the given input name.  The name
     *	must be valid or an exception will be thrown.
     */
    public Object getInputValue(String name);


    /**
     *	This method sets the specified output value.  The name must be valid or
     *	an exception will be thrown.
     */
    public void setOutputValue(String name, Object value);


    /**
     *	This method retrieves an output value that has already been set.
     */
    public Object getOutputValue(String name);
}
