/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view.descriptors;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;

import com.sun.enterprise.tools.guiframework.view.CCNodeEventHandlerViewBeanBase;


/**
 *
 */
public class CCNodeEventHandlerViewBeanBaseDescriptor extends ViewDescriptor {

    /**
     *	Constructor
     */
    public CCNodeEventHandlerViewBeanBaseDescriptor(String name) {
	super(name);
    }


    /**
     *	This is a factory method for CCNodeEventHandlerViewBeanBase instances.
     *
     *	@param	ctx	The RequestContext
     *	@param	na	This is not used -- this container is expected NOT to
     *			have a parent.
     *	@param	name	The name for the new CCNodeEventHandlerViewBeanBase
     */
    public View getInstance(RequestContext ctx, ContainerView na, String name) {
	return new CCNodeEventHandlerViewBeanBase(ctx, name, this);
    }
}
