/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view.descriptors;

import java.io.InputStream;
import java.util.Iterator;
import java.util.ArrayList;
import java.util.List;
import java.lang.reflect.Method;

import com.iplanet.jato.ModelManager;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.util.NonSyncStringBuffer;

import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.taglib.html.CCButtonTag;
import com.sun.web.ui.taglib.html.CCDropDownMenuTag;
import com.sun.web.ui.common.CCTagClass;
import com.sun.web.ui.taglib.common.CCDisplayFieldTagBase;
import com.sun.web.ui.model.CCPageTitleModelInterface;

import com.sun.enterprise.tools.guiframework.util.LogUtil;
import com.sun.enterprise.tools.guiframework.view.DescriptorCCPageTitle;

/**
 *
 */
public class CCPageTitleDescriptor extends ViewDescriptor {
    
    // XML string parts for the PageTitle model creation.
    private static final String xmlStart = 
        CCPageTitleModelInterface.XML_DELCARATION + "\n" +
        CCPageTitleModelInterface.DOCTYPE + "\n" +
        "<" + CCPageTitleModelInterface.PAGE_TITLE_ELEMENT + ">\n";
    
    private static final String xmlEnd = 
        "</" + CCPageTitleModelInterface.PAGE_TITLE_ELEMENT + ">\n";
    

    
    /**
     *	Constructor
     */
    public CCPageTitleDescriptor(String name) {
	super(name);
    }


    public void registerChildren(ContainerViewBase instance) {
	// Invoke the super registerChild
        super.registerChildren(instance);
	getModel().registerChildren(instance);
    }
    
    /**
     *	This method creates empty descriptors on the fly for fields that are
     *	defined by the underlying model.
     */
    public ViewDescriptor getChildDescriptor(String name) {
    	// Do the normal stuff if we can...
	ViewDescriptor desc = super.getChildDescriptor(name);
	if (desc != null) {
	    return desc;
	}

	// Do we need to create a descriptor on the fly?
	CCPageTitleModel model = getModel();
        if (model != null && model.isChildSupported(name)) {
	    // YES
	    desc = new CCPageTitleChildDescriptor(name);
	    // NOTE: This call is safe (mostly), because although we are
	    // NOTE: modifying a static structure... this change is applicable
	    // NOTE: to all users.  However, there is a slight possibility of
	    // NOTE: of a sync. problem... not worth worrying about now.  If
	    // NOTE: this does become a problem, just remove the
	    // NOTE: addChildDescriptor() line below.
	    addChildDescriptor(desc);
	    return desc;
	}
	return null;
    }
    
    private boolean isLegalTagAttribute(String name, CCDisplayFieldTagBase tag) {
        // checks if the attribute value is legal by reflection.
        char c = Character.toUpperCase(name.charAt(0));
	// Create method name for setting the attribute value.
	String methodName = "set" + c + name.substring(1);
	try {
	    // test for existence by try to retrieve the method.
	    Method method = tag.getClass().getMethod(
		methodName, new Class[] {String.class});
            if (method == null)
                return false;
	} catch (Exception e) {
	    return false;
	}
        return true;
    }
    
    private void addParameters(NonSyncStringBuffer buff, 
            CCDisplayFieldTagBase tag, ViewDescriptor desc) {
        Iterator it = desc.getParameterKeys().iterator();
        while (it.hasNext()) {
            String key = (String) it.next();
            if (isLegalTagAttribute(key, tag) == false) {
                 // parameters that are not illegal attributes of the given tag
                 // should not pass to the page title XML file. 
                 continue;
            }
            Object obj = desc.getParameter(key);
            String value = null;
            if (obj != null){
                value = obj.toString();
            }
            if (value != null) {
                buff.append("    <attribute name=\"")
                    .append(key)
                    .append("\" value=\"")
                    .append(value)
                    .append("\"/>\n");
            }
        }
    }
     
    private void appendPageActionButtons(NonSyncStringBuffer buff) {
	Iterator it = getChildDescriptors().iterator();
	ViewDescriptor desc = null;
        boolean first = true;
        
        while (it.hasNext()) {
            desc = (ViewDescriptor)it.next();
            String buttonType = (String) desc.getParameter("type");
            if (buttonType != null && 
                (buttonType.equals(CCButton.TYPE_PRIMARY) ||
                 buttonType.equals(CCButton.TYPE_SECONDARY) ||
                 buttonType.equals(CCDropDownMenu.TYPE_JUMP) ||
                 buttonType.equals(CCDropDownMenu.TYPE_STANDARD))) {
                // Consider all primary and secondary buttons as page buttons,
                // all others are page action buttons. The difference is where
                // they are placed on the page.
                continue;
            }
            Object show = desc.getParameter("showButton");
            if (show != null && show.toString().equals("false"))
                continue;
            String buttonName = desc.getName();
            if (buttonName == null)
                continue; // probably an error wo/ a name?
            
            if (first)
                buff.append(" <" + CCPageTitleModelInterface.PAGE_ACTIONS_ELEMENT + ">\n");

            buff.append("  <cc name=\"")
                .append(buttonName)
                .append("\" tagclass=\"" + CCTagClass.BUTTON + "\">\n");
            
            addParameters(buff, new CCButtonTag(), desc);     
            
            buff.append("  </cc>\n");
            first = false;
        }
        if (! first)
            buff.append(" </" + CCPageTitleModelInterface.PAGE_ACTIONS_ELEMENT + ">\n");
    }
    
    private void appendPageButtons(NonSyncStringBuffer buff) {
	Iterator it = getChildDescriptors().iterator();
	ViewDescriptor desc = null;
        boolean first = true;
        
        while (it.hasNext()) {
            desc = (ViewDescriptor)it.next();
            String buttonType = (String) desc.getParameter("type");
            if (buttonType == null ||
                (buttonType.equals(CCButton.TYPE_PRIMARY) == false &&
                 buttonType.equals(CCButton.TYPE_SECONDARY) == false)) {
                // Consider all primary and secondary buttons as page buttons,
                // all others are page action buttons. The difference is where
                // they are placed on the page.
                continue;
            }
            String show = (String) desc.getParameter("showButton");
            if (show != null && show.equals("false"))
                continue;
            String buttonName = desc.getName();
            if (buttonName == null)
                continue; // probably an error without a name?
            
            if (first)
                buff.append(" <" + CCPageTitleModelInterface.PAGE_BUTTONS_ELEMENT + ">\n");

            buff.append("  <cc name=\"")
                .append(buttonName)
                .append("\" tagclass=\"" + CCTagClass.BUTTON + "\">\n");
                
            addParameters(buff, new CCButtonTag(), desc);                
                
            buff.append("  </cc>\n");
            first = false;
        }
        if (! first)
            buff.append(" </" + CCPageTitleModelInterface.PAGE_BUTTONS_ELEMENT + ">\n");
    }
    
    private void addOptionList(NonSyncStringBuffer buff, ViewDescriptor desc)  {
	Object options = desc.getParameter("labels");
	if (options != null) {
	    if (options instanceof String) {
		List tmp = new ArrayList();
		tmp.add(options);
		options = tmp;
	    }
	    List optionList = (List)options;

	    Object values = desc.getParameter("values");
	    List valueList = optionList;
	    if (values != null) {
		if (values instanceof String) {
		    List tmp = new ArrayList();
		    tmp.add(values);
		    values = tmp;
		}
		valueList = (List)values;
		if (valueList.size() != optionList.size()) {
		    throw new RuntimeException(
			"Unequal number of option names / values! " +
                        "(CCPageTitleDescriptor.addOptionList)");
		}
	    }
            for (int i=0; i<valueList.size(); i++) {
                buff.append("    <option label=\"").append(optionList.get(i))
                    .append("\" value=\"").append(valueList.get(i))
                    .append("\"/>\n");
            }
        }
    }
    
    private void appendPageViewDropDown(NonSyncStringBuffer buff) {
	Iterator it = getChildDescriptors().iterator();
	ViewDescriptor desc = null;
        boolean first = true;
        
        while (it.hasNext()) {
            desc = (ViewDescriptor)it.next();
            String type = (String) desc.getParameter("type");
            if (type == null || 
                (type.equals(CCDropDownMenu.TYPE_JUMP) == false &&
                 type.equals(CCDropDownMenu.TYPE_STANDARD) == false)) {
                    continue;
            }
            String name = desc.getName();
            if (name == null)
                continue; // probably an error without a name?
            
            if (first)
                buff.append(" <" + CCPageTitleModelInterface.PAGE_VIEWS_ELEMENT + ">\n");

            buff.append("  <cc name=\"").append(name)
                .append("\" tagclass=\"" + CCTagClass.DROPDOWNMENU + "\">\n");
                
            addParameters(buff, new CCDropDownMenuTag(), desc);
            addOptionList(buff, desc);
                
            buff.append("  </cc>\n");
            first = false;
        }
        if (! first)
            buff.append(" </" + CCPageTitleModelInterface.PAGE_VIEWS_ELEMENT + ">\n");
    }
    
    private String getPageTitleXML() {
        NonSyncStringBuffer buff = new NonSyncStringBuffer(2048);
        buff.append(xmlStart);
        
        appendPageButtons(buff);
        appendPageActionButtons(buff);
        appendPageViewDropDown(buff);
        
        buff.append(xmlEnd);

	// Log Trace Message
	if (LogUtil.isLoggable(LogUtil.FINEST)) {
	    LogUtil.log(LogUtil.FINEST, "trace.pageTitleXML", buff.toString());
	}
        return buff.toString();
    }

    private InputStream getPageTitleXMLAsStream() {
	ViewDescriptor desc = this;
	InputStream is = null;
	is = (InputStream)desc.getParameter("fileAsStream");
	return is;
    }


    /**
     *	This method overrides the super class method to provide a more unique
     *	instance name.  Page titles from one ViewBean to the next may often
     *	share the same name, so their name is not unique enough.  Instead,
     *	this method uses the top ViewDescriptor's name (i.e. the ViewBean
     *	name).
     *
     *	@return	The default model instance name (the top ViewDescriptor for
     *		this implementation).
     */
    public String getDefaultModelInstanceName() {
	// Find the top ViewDescriptor
	ViewDescriptor top = this;
	while (top.getParent() != null) {
	    top = top.getParent();
	}

	// Return the top ViewDescriptor's name + the current VD name
	return top.getName()+"."+getName();
    }


    /**
     *
     */
    public CCPageTitleModel getModel() {
        // Determine if the session should be used w/ the model manager.
	boolean fromSession = shouldGetModelFromSession();
	boolean toSession = shouldPutModelToSession();
	String instanceName = getModelInstanceName();

	// Use the ModelManager to create/get the model
	ModelManager mgr = RequestManager.getRequestContext().getModelManager();
	CCPageTitleModel model = (CCPageTitleModel)mgr.getModel(
            CCPageTitleModel.class, instanceName, fromSession, toSession);
        // Get the XML document
	InputStream is = null;	
	//Make sure document is not in the model, look CCActionTable for a 
	//similar call
	if(model.getDocument() == null) {
		if((is = getPageTitleXMLAsStream()) != null) {
		    	model.setDocument(is);
			try {
		    		is.close();
			} catch (java.io.IOException ex) {
				//Ignore
			}
		} 
		else {
        		model.setDocument(getPageTitleXML());
		}
	}
        return model;
    }


    /**
     *	This is a factory method for CCActionTable instances.
     *
     *	@param	ctx	The RequestContext
     *	@param	container	The container for the newly created 
     */
    public View getInstance(RequestContext ctx, ContainerView container, String name) {
	return new DescriptorCCPageTitle(ctx, container, name, this, getModel());
    }
}
