/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/config/ClusterConfigImpl.java,v 1.13 2006/03/17 03:34:15 llc Exp $
 * $Revision: 1.13 $
 * $Date: 2006/03/17 03:34:15 $
 */


package com.sun.enterprise.management.config;

import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Collections;

import javax.management.ObjectName;
import com.sun.enterprise.management.config.AMXConfigImplBase;
import com.sun.enterprise.management.support.Delegate;
	
import com.sun.appserv.management.config.ClusterConfig;
import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.Util;

import com.sun.enterprise.management.support.AMXAttributeNameMapper;

/**
	Configuration for the &lt;cluster&gt; element.
 */
public final class ClusterConfigImpl extends AMXConfigImplBase
	// implements ClusterConfig
	implements ConfigFactoryCallback
{
		public
	ClusterConfigImpl( final Delegate delegate )
	{
		super( delegate );
	}
	
	    private ClusterConfig
	self()
	{
	    return (ClusterConfig)getSelf();
	}
	
		protected void
	addCustomMappings( final AMXAttributeNameMapper mapper )
	{
	    super.addCustomMappings( mapper );
		mapper.matchName( "ReferencedConfigName", "config-ref" );
	}
	
	
                
		public Map<String,ObjectName>
	getClusteredServerConfigObjectNameMap()
	{
		final Map<String,ObjectName> serverRefConfigMap =
		    Util.toObjectNames( self().getServerRefConfigMap() );
		if ( serverRefConfigMap.isEmpty() )
		{
			return new HashMap<String,ObjectName>();
		}
		
		final Set<ObjectName> allClusteredServerConfigObjectNames = 
			getQueryMgr().queryJ2EETypeObjectNameSet( XTypes.CLUSTERED_SERVER_CONFIG );
		final Map<String,ObjectName> objectNameMap =
		    Util.createObjectNameMap( allClusteredServerConfigObjectNames );

		final Map<String,ObjectName> clusteredServerConfigObjectNameMap = 
			new HashMap<String,ObjectName>( allClusteredServerConfigObjectNames.size() );

		for( final String key : serverRefConfigMap.keySet() )
		{
			clusteredServerConfigObjectNameMap.put( key, objectNameMap.get( key ) );
		}
		return clusteredServerConfigObjectNameMap;
	}
	
	
}



