/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/config/MessageSecurityConfigFactory.java,v 1.4 2006/03/09 20:30:40 llc Exp $
 * $Revision: 1.4 $
 * $Date: 2006/03/09 20:30:40 $
 */
package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.Set;
import java.util.Collections;

import javax.management.ObjectName;
import javax.management.AttributeList;

import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.management.support.oldconfig.OldSecurityServiceMBean;

import com.sun.appserv.management.util.misc.GSetUtil;


import com.sun.appserv.management.config.MessageSecurityConfigKeys;

/**
 */
public final class MessageSecurityConfigFactory extends ConfigFactory 
{
	private final OldSecurityServiceMBean	mOldSecurityServiceMBean;
	
		public
	MessageSecurityConfigFactory(
		final ConfigFactoryCallback	callbacks,
		final OldSecurityServiceMBean	old)
	{
		super( callbacks );
		
		mOldSecurityServiceMBean	= old;
	}
	
	private final Set<String>	LEGAL_OPTIONAL_KEYS	= 
		GSetUtil.newUnmodifiableSet(
		    MessageSecurityConfigKeys.DEFAULT_PROVIDER_KEY,
		    MessageSecurityConfigKeys.DEFAULT_CLIENT_PROVIDER_KEY );
	
	    protected Set<String>
	getLegalOptionalCreateKeys()
	{
		return( LEGAL_OPTIONAL_KEYS );
	}
	
	
	
		public ObjectName	
    create( String authLayer, Map<String,String> optional )
	{
		final Map<String,String> params = initParams( authLayer, null, optional );

		final ObjectName amxName = createNamedChild( authLayer, params );

		return amxName;
	}


		protected final void		
	removeByName( final String authLayer )
	{
		mOldSecurityServiceMBean.removeMessageSecurityConfigByAuthLayer( authLayer );
	}

	/**
		The caller is responsible for dealing with any Properties.
	 */
		protected ObjectName
	createOldChildConfig( final AttributeList translatedAttrs )
	{
		return mOldSecurityServiceMBean.createMessageSecurityConfig( translatedAttrs );
	}

		protected Map<String,String>
	getParamNameOverrides()
	{
		return( MapUtil.newMap( AMXConfig.NAME_KEY, "AuthLayer" ) );
	}

}




