/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/config/ModuleLogLevelsConfigFactory.java,v 1.5 2006/03/09 20:30:40 llc Exp $
 * $Revision: 1.5 $
 * $Date: 2006/03/09 20:30:40 $
 */


package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.Set;
import java.util.Collections;

import javax.management.ObjectName;
import javax.management.AttributeList;

import com.sun.enterprise.management.support.oldconfig.OldLogServiceMBean;	

import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.config.ModuleLogLevelsConfigKeys;

public final class ModuleLogLevelsConfigFactory  extends ConfigFactory
{
	private final OldLogServiceMBean	mOldLogServiceMBean;
	
		public
	ModuleLogLevelsConfigFactory(
		final ConfigFactoryCallback	callbacks,
		final OldLogServiceMBean	old )
	{
		super( callbacks );
		
		mOldLogServiceMBean	= old;
	}
	
	
	private final Set<String>	LEGAL_OPTIONAL_KEYS	= 
		GSetUtil.newUnmodifiableStringSet( 
		ModuleLogLevelsConfigKeys.ROOT_KEY,
		ModuleLogLevelsConfigKeys.SERVER_KEY,
		ModuleLogLevelsConfigKeys.EJB_CONTAINER_KEY,
		ModuleLogLevelsConfigKeys.CMP_CONTAINER_KEY,
		ModuleLogLevelsConfigKeys.MDB_CONTAINER_KEY,
		ModuleLogLevelsConfigKeys.WEB_CONTAINER_KEY,
		ModuleLogLevelsConfigKeys.CLASSLOADER_KEY,
		ModuleLogLevelsConfigKeys.CONFIGURATION_KEY,
		ModuleLogLevelsConfigKeys.NAMING_KEY,
		ModuleLogLevelsConfigKeys.SECURITY_KEY,
		ModuleLogLevelsConfigKeys.JTS_KEY,
		ModuleLogLevelsConfigKeys.JTA_KEY,
		ModuleLogLevelsConfigKeys.ADMIN_KEY,
		ModuleLogLevelsConfigKeys.DEPLOYMENT_KEY,
		ModuleLogLevelsConfigKeys.VERIFIER_KEY,
		ModuleLogLevelsConfigKeys.JAXR_KEY,
		ModuleLogLevelsConfigKeys.JAXRPC_KEY,
		ModuleLogLevelsConfigKeys.SAAJ_KEY,
		ModuleLogLevelsConfigKeys.CORBA_KEY,
		ModuleLogLevelsConfigKeys.JAVAMAIL_KEY,
		ModuleLogLevelsConfigKeys.JMS_KEY,
		ModuleLogLevelsConfigKeys.CONNECTOR_KEY,
		ModuleLogLevelsConfigKeys.JDO_KEY,
		ModuleLogLevelsConfigKeys.CMP_KEY,
		ModuleLogLevelsConfigKeys.UTIL_KEY,
		ModuleLogLevelsConfigKeys.RESOURCE_ADAPTER_KEY,
		ModuleLogLevelsConfigKeys.SYNCHRONIZATION_KEY,
		ModuleLogLevelsConfigKeys.NODE_AGENT_KEY );
	
	    protected Set<String>
	getLegalOptionalCreateKeys()
	{
		return( LEGAL_OPTIONAL_KEYS );
	}
	
		public ObjectName
	create( Map<String,String> optional )
	{
		final Map<String,String>		params			= initParams( optional );

		final ObjectName	amxName	= createChild( params );
		
		return( amxName );
	}

		protected ObjectName
	createOldChildConfig( String oldType, AttributeList attrs )
	{
		final ObjectName old = mOldLogServiceMBean.createModuleLogLevels( attrs );
		return old;
	}

		protected void
	internalRemove( final ObjectName objectName )
	{
		mOldLogServiceMBean.removeModuleLogLevels();
	}

}

