/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Map;

import javax.management.ObjectName;
import javax.management.AttributeList;

import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.management.support.oldconfig.OldMessageSecurityConfigMBean;

/**
 */
public final class ProviderConfigFactory extends ConfigFactory 
	// implements ProviderConfigMgr
{
	private final OldMessageSecurityConfigMBean	mOldMessageSecurityConfigMBean;
	
	public ProviderConfigFactory(final ConfigFactoryCallback	callbacks)
	{
		super( callbacks );
		
		mOldMessageSecurityConfigMBean   = getOldMessageSecurityConfigMBean();
	}
	
		private final OldMessageSecurityConfigMBean
	getOldMessageSecurityConfigMBean()
	{
		final String name   = getFactoryContainer().getName();
		return getOldConfigProxies().getOldMessageSecurityConfigMBean( name );
	}

	private static final String	PROVIDER_TYPE_KEY	= "ProviderType";
	private static final String	CLASSNAME_KEY		= "ClassName";

		protected Map<String,String>
	getParamNameOverrides(  )
	{
		return( MapUtil.newMap(AMXConfig.NAME_KEY, "ProviderId"));
	}                

		protected ObjectName
	createOldChildConfig( final AttributeList translatedAttrs)
	{
		return mOldMessageSecurityConfigMBean.createProviderConfig( translatedAttrs );
	}


		public ObjectName
	create(
		final String providerId,
		final String providerType, 
		final String className,
		final Map<String,String> reserved)
	{
		final String[] requiredParams =
		{	
			PROVIDER_TYPE_KEY,	providerType,
			CLASSNAME_KEY,		className,	
		};

		final Map<String,String> params = initParams( providerId, requiredParams,  reserved );
		final ObjectName amxName = createNamedChild( providerId, params );

		return amxName;
	}

		protected final void
	removeByName(String providerId)
	{
		mOldMessageSecurityConfigMBean.removeProviderConfigByProviderId(providerId);
	}
}




