/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.support;

import java.util.Map;
import java.util.HashMap;
import java.util.Collections;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.MBeanServerNotification;

import com.sun.appserv.management.base.NotificationServiceMgr;
import com.sun.appserv.management.base.NotificationService;
import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.base.Util;

import com.sun.enterprise.management.support.UniqueIDGenerator;


/**
 */
public class NotificationServiceMgrImpl extends AMXImplBase
	implements NotificationListener
{
	private final Map<ObjectName,NotificationServiceImpl> mServices;
	private final UniqueIDGenerator	mUniqueIDs;
	
		public
	NotificationServiceMgrImpl()
	{
		mServices	= Collections.synchronizedMap( new HashMap<ObjectName,NotificationServiceImpl>() );
		
		mUniqueIDs	= new UniqueIDGenerator( "notif-service-" );
	}
	
		public void
	handleNotification(
		final Notification	notifIn, 
		final Object		handback) 
	{
		final String	type	= notifIn.getType();
		
		// ensure that if a NotificationService is unregistered that we remove
		// it from our list
		if ( type.equals( MBeanServerNotification.UNREGISTRATION_NOTIFICATION)  )
		{
			final MBeanServerNotification	notif	= (MBeanServerNotification)notifIn;
			final ObjectName	objectName	= notif.getMBeanName();
			
			if ( Util.getJ2EEType( objectName ).
					equals( XTypes.NOTIFICATION_SERVICE ) )
			{
				mServices.remove( objectName );
			}
		}
	}

		public String
	getGroup()
	{
		return( AMX.GROUP_UTILITY );
	}
	
	/*
	
		public Map
	getNotificationServiceObjectNameMap()
	{
		return( getContaineeObjectNameMap( XTypes.NOTIFICATION_SERVICE ) );
	}
	*/
	
		public void
	preRegisterDone()
		throws Exception
	{
		JMXUtil.listenToMBeanServerDelegate( getMBeanServer(), this, null, null );
	}
	
	
		public ObjectName
	createNotificationService(
		final Object	userData,
		final int		bufferSize )
	{
		final NotificationServiceImpl	service	=
			new NotificationServiceImpl( userData, bufferSize );
		
		final ObjectName	self	= getObjectName();
		
		final String	domain		= self.getDomain();
		final String	childName	= mUniqueIDs.createID().toString();
		final String	requiredProps	=
			Util.makeRequiredProps( XTypes.NOTIFICATION_SERVICE, childName );
		
		final ObjectName	tempName	= JMXUtil.newObjectName( domain, requiredProps );
		
		ObjectName	objectName	= null;
		try
		{
			objectName	= registerMBean( service, tempName );
			mServices.put( objectName, service );
		}
		catch( Exception e )
		{
			throw new RuntimeException( e );
		}
		
		return( objectName );
	}
	
		public ObjectName
	getNotificationServiceObjectName( final String name  )
	{
		return( getContaineeObjectName( XTypes.NOTIFICATION_SERVICE, name ) );
	}
	
		public synchronized void
	removeNotificationService( final String name )
		throws InstanceNotFoundException
	{
		final ObjectName	objectName	= getNotificationServiceObjectName( name );
		if ( objectName == null )
		{
			throw new IllegalArgumentException( name );
		}
		
		if ( ! mServices.containsKey( objectName ) )
		{
			throw new InstanceNotFoundException( objectName.toString() );
		}
		
		try
		{
			getMBeanServer().unregisterMBean( objectName );
		}
		catch( MBeanRegistrationException e )
		{
			throw new RuntimeException( e );
		}
		
		// remove it after unregistering it, in case an exception is thrown
		mServices.remove( objectName );
	}
	
}











