/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.support.oldconfig;

import javax.management.ObjectName;
import javax.management.AttributeList;

import java.util.Set;
import java.util.List;
import java.util.Properties;

public interface OldManagementRules 
{
    /**
        Taken from com.sun.enterprise.admin.mbeans.ManagementRulesMBean
     
        Create new self management rule with contained event and action(optional)
        @param ruleName          name of the management rule. Required.
        @param bRuleEnabled      enabled/disabled rule state.  
        @param ruleDescription   textual decription of the rule.
        @param eventType         one of the predefined event types. Required. 
        @param eventLevel        events severety level (default "INFO")
        @param eventDescription  textual decription of the evant
        @param eventRecordEvent  whether the event is to be logged or not ("true")
        @param eventProperties   event's properties
        @param actionMbeanName   actionMbeanNames associated with rule 

        @returns ObjectName of created management-rule
        @throws Exception
     */
public ObjectName createManagementRule(
            String  ruleName,           //required
            Boolean bRuleEnabled,
            String  ruleDescription,
            String  eventType,          //required
            String  eventLevel,         
            Boolean eventRecordEvent,   
            String  eventDescription,   
            Properties eventProperties,
            String  actionMbeanName
        );


    ObjectName createManagementRule(AttributeList a);
    void addActionToManagementRule(String ruleName,String actionMBeanName);
    List getAllActionMBeans(boolean p);
    List getDottedNames(String p);
    List getEventProperties(String p);
    List getEventPropertyValues(String p1,String p2);
    List getEventTypes(boolean p);
    List getMBeanAttributes(String p);
    ObjectName[] getManagementRule();
    ObjectName getManagementRuleByName(String p);
    String[] getManagementRuleNamesList();
    List getNotificationTypes(String p);
    List getNotificationTypes(ObjectName p);
    Set getRegisteredMBeans(String p);
    void removeManagementRuleByName(String p);
    
};




