/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Map;

import javax.management.ObjectName;

import com.sun.appserv.management.util.jmx.MBeanServerConnectionConnectionSource;
import com.sun.appserv.management.util.misc.ExceptionUtil;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.base.XTypes;

import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.config.SecurityServiceConfig;
import com.sun.appserv.management.config.JACCProviderConfig;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;

/**
 */
public final class JACCProviderConfigTest extends ConfigMgrTestBase
{
	static final String PROVIDER			= "com.sun.enterprise.security.provider.PolicyWrapper";
	static final String	PROVIDER_FACTORY	= "com.sun.enterprise.security.provider.PolicyConfigurationFactoryImpl";
	static final Map<String,String>	RESERVED			= null;

		public
	JACCProviderConfigTest()
	{
	    if ( checkNotOffline( "ensureDefaultInstance" ) )
	    {
	        ensureDefaultInstance( getConfigConfig().getSecurityServiceConfig() );
	    }
	}
	     public static String
    getDefaultInstanceName()
    {
        return getDefaultInstanceName( "JACCProviderConfig" );
    }
    
	    public static JACCProviderConfig
	ensureDefaultInstance( final SecurityServiceConfig ss )
	{
	    JACCProviderConfig result = ss.getJACCProviderConfigMap().get( getDefaultInstanceName() );
	    
	    if ( result == null )
	    {
	        result  = createInstance( ss, getDefaultInstanceName(), PROVIDER, PROVIDER_FACTORY );
	    }
	    
	    return result;
	}
	
	    public static JACCProviderConfig
	createInstance(
	    final SecurityServiceConfig ss,
	    final String    name,
	    final String    policyProvider,
	    final String    policyConfigurationFactoryProvider )
	{
	    return ss.createJACCProviderConfig( name,
	        policyProvider, policyConfigurationFactoryProvider, null );
	}
	
	
		protected Container
	getProgenyContainer()
	{
		return getConfigConfig().getSecurityServiceConfig();
	}

		protected String
	getProgenyJ2EEType()
	{
		return XTypes.JACC_PROVIDER_CONFIG;
	}


		protected void
	removeProgeny( final String name )
	{
		getConfigConfig().getSecurityServiceConfig().removeJACCProviderConfig( name );
	}

		protected final AMXConfig
	createProgeny(final String name, final Map<String,String> options )
	{
		return getConfigConfig().getSecurityServiceConfig().createJACCProviderConfig(name, PROVIDER, PROVIDER_FACTORY, options);
	}
}


