/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.deploy;

import java.util.Map;

import java.io.IOException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

import com.sun.appserv.management.deploy.DeploymentSource;
import com.sun.appserv.management.deploy.DeploymentSourceImpl;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;

/**
 */
public final class DeploymentSourceTest extends junit.framework.TestCase
{
		public
	DeploymentSourceTest( )
	{
	}
	
		private DeploymentSourceImpl
	createDeploymentSource()
		throws IOException
	{
		final File	archiveFile	= File.createTempFile( "junk", "junk" );
		archiveFile.deleteOnExit();
		
		final String[]	entriesAdded	= new String[]	{ "hello", "there" };
		final String[]	entriesRemoved	= new String[0];
		final String[]	entriesDeleted	= new String[0];
		final DeploymentSourceImpl	ds	=
			new DeploymentSourceImpl( archiveFile.toString(),
				true,
				entriesAdded, entriesRemoved, entriesDeleted, null );
		
		return( ds );
	}
	
		public void
	testCreateDeploymentSource()
		throws IOException
	{
		createDeploymentSource();
	}
	
	
		public void
	testDeploymentSourceFromMap()
		throws IOException
	{
		final DeploymentSourceImpl	ds	= createDeploymentSource();
		final Map<String,Serializable>	data	= ds.asMap();
		
		final DeploymentSourceImpl ds2	= new DeploymentSourceImpl( data );
		
		assert( ds2.equals( ds ) );
		assert( ds.equals( ds2 ) );
	}
	
	
}


























