/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/tests/com/sun/enterprise/management/monitor/BeanCacheMonitorTest.java,v 1.4 2005/12/25 03:41:53 tcfujii Exp $
 * $Revision: 1.4 $
 * $Date: 2005/12/25 03:41:53 $
 */
package com.sun.enterprise.management.monitor;

import javax.management.ObjectName;

import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;

import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.BoundaryStatistic;
import javax.management.j2ee.statistics.RangeStatistic;
import javax.management.j2ee.statistics.BoundedRangeStatistic;
import javax.management.j2ee.statistics.TimeStatistic;

			
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.QueryMgr;
import com.sun.appserv.management.monitor.BeanCacheMonitor;
import com.sun.appserv.management.monitor.statistics.EJBCacheStats;

import com.sun.appserv.management.j2ee.statistics.*;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;


public final class BeanCacheMonitorTest
	extends AMXMonitorTestBase
{
    	public
    BeanCacheMonitorTest()
    {
    }
    
  
  		public void
  	testStats()
  	{
  		final QueryMgr	q	= getQueryMgr();
  		
  		final Set	beanCacheMonitors	= q.queryJ2EETypeSet( XTypes.BEAN_CACHE_MONITOR );
  		
  		if (  beanCacheMonitors.size() == 0 )
  		{
  			warning( "BeanCacheMonitorTest: no MBeans found to test." );
  		}
  		else
  		{
  			final Iterator	iter	= beanCacheMonitors.iterator();
  			
  			while ( iter.hasNext() )
  			{
  				final BeanCacheMonitor	m	= (BeanCacheMonitor)iter.next();
  				final EJBCacheStats		s	= m.getEJBCacheStats();
  				
  				// verify that we can get each Statistic; there was a problem at one time
			  	final BoundedRangeStatistic b1	= s.getCacheMisses();
			    final BoundedRangeStatistic b2	= s.getCacheHits();
			    final BoundedRangeStatistic b3	= s.getBeansInCache();
			    
			    // these were failing
			    final CountStatistic c4 = s.getPassivationSuccesses();
			    final CountStatistic c3	= s.getExpiredSessionsRemoved();
			    final CountStatistic c2	= s.getPassivationErrors();
			    final CountStatistic c1	= s.getPassivations();

  			}
  		}
  	}
 
}






