/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.monitor;

import java.util.Set;
import java.util.Iterator;

import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.RangeStatistic;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.QueryMgr;
import com.sun.appserv.management.monitor.JDBCConnectionPoolMonitor;
import com.sun.appserv.management.monitor.statistics.AltJDBCConnectionPoolStats;
import com.sun.appserv.management.monitor.MonitoringStats;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;


public final class JDBCConnectionPoolStatsTest
	extends ConnectionPoolStatsTest
{
    	public
    JDBCConnectionPoolStatsTest()
    {
    }
  
  
  	
  		public void
  	nextMonitor( final MonitoringStats ms)
  	{
		final JDBCConnectionPoolMonitor		m	= (JDBCConnectionPoolMonitor)ms;
		final AltJDBCConnectionPoolStats	s	= m.getAltJDBCConnectionPoolStats();
		
		accessAllStatistics( s );
  	}
  	
  	
  		public void
  	testJDBCConnectionPoolStats()
  	{
		final long	start	= now();
		
  		final int	numMonitors	= iterateAllMonitors( XTypes.JDBC_CONNECTION_POOL_MONITOR );
  		
		printElapsed( "testConnectorConnectionPoolStats", numMonitors, start );
  	}
 
}






