/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.util.jmx;

import javax.management.ObjectName;

import com.sun.appserv.management.util.jmx.ObjectNameComparator;
import com.sun.appserv.management.util.jmx.JMXUtil;


public class ObjectNameComparatorTest extends junit.framework.TestCase
{
    private final ObjectNameComparator   mComparator;
    
        public
    ObjectNameComparatorTest()
    {
        super( "ObjectNameComparatorTest" );
        
        mComparator = ObjectNameComparator.INSTANCE;
    }

       private ObjectName
    newObjectName( final String s )
    {
        return JMXUtil.newObjectName( s );
    }
    

        public void
    testEquals()
    {
        final ObjectName  name1   = newObjectName( "amx:j2eeType=FOO,name=FOO-NAME" );
        final ObjectName  name2   = newObjectName( "amx:name=FOO-NAME,j2eeType=FOO" );
        
        assert mComparator.compare( name1, name2 ) == 0;
        assert mComparator.compare( name2, name1 ) == 0;
    }
    
        public void
    testUnequal()
    {
        final ObjectName  name1   = newObjectName( "amx:j2eeType=FOO,name=FOO-NAME" );
        final ObjectName  name2   = newObjectName( "amx:name=FOO-NAME,j2eeType=FOO" );
        
        final ObjectName  name3   = newObjectName( "amx:j2eeType=FOO,name=FOO-BAR" );
        final ObjectName  name4   = newObjectName( "amx:name=FOO-BAR,j2eeType=FOO" );
        
        final ObjectName  nameA     = newObjectName( "amx:name=A" );
        final ObjectName  nameB     = newObjectName( "amx:name=B" );
        
        final ObjectName  bbb     = newObjectName( "bbb:name=foo" );
        
        assert mComparator.compare( name1, name2 ) == 0;
        assert mComparator.compare( name2, name1 ) == 0;
        assert mComparator.compare( name3, name4 ) == 0;
        assert mComparator.compare( name4, name3 ) == 0;
        
        assert mComparator.compare( name1, name3 ) > 0;
        assert mComparator.compare( name2, name3 ) > 0;
        assert mComparator.compare( name3, name1 ) < 0;
        assert mComparator.compare( name3, name2 ) < 0;
        
        assert mComparator.compare( name1, name4 ) > 0;
        assert mComparator.compare( name2, name4 ) > 0;
        assert mComparator.compare( name4, name2 ) < 0;
        assert mComparator.compare( name4, name1 ) < 0;
        
        assert mComparator.compare( name1, nameA ) < 0;
        assert mComparator.compare( nameA, name1 ) > 0;
        
        assert mComparator.compare( nameA, nameB ) < 0;
        assert mComparator.compare( nameB, nameA ) > 0;
        
        assert mComparator.compare( name1, bbb ) < 0;
        assert mComparator.compare( bbb, name1 ) > 0;
    }
	
}






























