/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeans/src/java/com/sun/enterprise/admin/dottedname/DottedNameServerInfoImpl.java,v 1.3 2005/12/25 03:42:05 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:42:05 $
 */


package com.sun.enterprise.admin.dottedname;

import java.util.HashSet;
import java.util.Set;
import java.util.Collections;

import javax.management.ObjectName;
import javax.management.MalformedObjectNameException;
import javax.management.AttributeNotFoundException;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;

import com.sun.enterprise.admin.util.ArrayConversion;

import com.sun.enterprise.admin.common.ObjectNames;


import javax.management.MBeanServerInvocationHandler;


/*
	This is the 'glue' that knows how to get server names, and how to get
	config names from server names, etc.  It isolates the DottedNameResolverForAliases
	code from direct knowledge of the server structure.
 */
public class DottedNameServerInfoImpl implements DottedNameServerInfo
{
	final MBeanServerConnection	mConn;
	
	
		public
	DottedNameServerInfoImpl( MBeanServerConnection conn )
	{
		mConn	= conn;
	}
	
		ObjectName
	getControllerObjectName()
	{
		return( ObjectNames.getControllerObjectName() );
	}
	
		ObjectName
	getConfigsObjectName()
		throws MalformedObjectNameException
	{
		return( new ObjectName( "com.sun.appserv:type=configs,category=config" )  );
	}
	
		ObjectName
	getServerObjectName( final String serverName )
	{
		return( ObjectNames.getServerObjectName( serverName ) );
	}
	
	
		Set
	_getConfigNames()
		throws ReflectionException, InstanceNotFoundException, MBeanException, java.io.IOException,
		MalformedObjectNameException, AttributeNotFoundException
	{
		// we can't use a proxy; it won't work when the method name starts with "get", apparently
		// thinking it's an Attribute
		final ObjectName []	configObjectNames	=
			(ObjectName [])mConn.invoke( getConfigsObjectName(), "getConfig", null, null );
		
		final HashSet	configNames	= new HashSet();
		for( int i = 0; i < configObjectNames.length; ++i )
		{
			final String	name	= (String)mConn.getAttribute( configObjectNames[ i ], "name" );
			
			configNames.add( name );
		}
		
		return( configNames );
	}
	
		public Set
	getConfigNames()
		throws DottedNameServerInfo.UnavailableException
	{
		Set	namesSet	= null;
		
		try
		{
			namesSet	= _getConfigNames();
		}
		catch( Exception e )
		{
			throw new DottedNameServerInfo.UnavailableException( e );
		}
		
		return( namesSet );
	}
	
	// used to create a proxy to controller mbean
	private interface MyController
	{
		String []	listServerInstances();
	};
	
		protected Set
	_getServerNames()
		throws ReflectionException, InstanceNotFoundException, MBeanException, java.io.IOException
	{
		final MyController	controller	= (MyController)
			MBeanServerInvocationHandler.newProxyInstance( mConn, getControllerObjectName(), MyController.class, false );
		
		final String []	names	= controller.listServerInstances();
		
		return( ArrayConversion.toSet( names ) );
	}
	
		public Set
	getServerNames()
		throws DottedNameServerInfo.UnavailableException
	{
		Set	namesSet	= null;
		
		try
		{
			namesSet	= _getServerNames();
		}
		catch( Exception e )
		{
			throw new DottedNameServerInfo.UnavailableException( e );
		}
		
		return( namesSet );
	}
	
		public String
	getConfigNameForServer( String serverName )
		throws DottedNameServerInfo.UnavailableException
	{
		final ObjectName	serverObjectName	= getServerObjectName( serverName );
		
		if ( serverObjectName == null )
		{
			throw new DottedNameServerInfo.UnavailableException( serverObjectName.toString() );
		}
		
		String	configName	= null;
		try
		{
			configName	= (String)mConn.getAttribute( serverObjectName, "config_ref" );
		}
		catch( Exception e )
		{
			throw new DottedNameServerInfo.UnavailableException( e );
		}
		
		return( configName );
	}
	
		public String []
	getServerNamesForConfig( String configName )
		throws DottedNameServerInfo.UnavailableException
	{
		final java.util.Iterator iter			= getServerNames().iterator();
		final java.util.ArrayList	namesOut	= new java.util.ArrayList();
		
		while ( iter.hasNext() )
		{
			final String	serverName	= (String)iter.next();
			
			if ( configName.equals( getConfigNameForServer( serverName ) ) )
			{
				namesOut.add( serverName );
			}
		}
		
		final String []	namesOutArray	= new String [ namesOut.size() ];
		namesOut.toArray( namesOutArray );
		
		return( namesOutArray );
	}
}









