/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeans/src/java/com/sun/enterprise/admin/dottedname/valueaccessor/PrefixedValueSupport.java,v 1.3 2005/12/25 03:42:07 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:42:07 $
 */
package com.sun.enterprise.admin.dottedname.valueaccessor;

import javax.management.MBeanServerConnection;
public class PrefixedValueSupport
{
    PropertyValueAccessorBase[] accessors = null;
    
    public PrefixedValueSupport(MBeanServerConnection conn)
    {
        accessors = new PropertyValueAccessorBase[]{
           new PropertyValueAccessor(conn), // regular property accessor
           new SystemPropertyValueAccessor(conn) // system property accessor
        };
    }
    
    public boolean isPrefixedValueDottedName(String dottedName)
    {
        if(getPrefixedValueAccessor(dottedName)!=null)
                return true;
        return false;
    }
    
   public String getPrefixedValueName(String dottedName)
    {
        return getPrefixedValueName(dottedName, false);
    }
    
    public String getPrefixedValueName(String dottedName, boolean bIncludingPrefix)
    {
        PropertyValueAccessorBase acc;
        if((acc=getPrefixedValueAccessor(dottedName))!=null)
               return acc.extractPrefixedValueName(dottedName, bIncludingPrefix);
        return null;
    }
    
    public PropertyValueAccessorBase getPrefixedValueAccessor(String dottedName)
    {
        for(int i=0; i<accessors.length; i++)
            if(accessors[i].isDottedNameForAccessor(dottedName))
               return accessors[i];
        return null;
    }
    
}


