/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.mbeans;

import javax.management.ObjectName;
import javax.management.MBeanServerConnection;

/**
 * Provides for determining the state of servers within the
 * scope of this domain
 *
 * @author Sreenivas Munnangi
 */

public interface DomainStatusMBean {

    /**
     * attribute name for state
     */
    public static final String DOMAIN_STATUS_STATE = "state";

    /**
     * name of this mbean
     */
    public static final String DOMAIN_STATUS_PROPS = "name=domain-status";

    /**
     * type of the Notification emitted when the status of a server changes
     */
    public final String SERVER_STATUS_NOTIFICATION_TYPE = 
	"com.sun.appserv.management.status.ServerStatusChanged";

    /**
     * key within the Notification's Map of type
     * SERVER_STATUS_NOTIFICATION_TYPE which yields the serverName
     */
    public final String SERVER_NAME_KEY = "ServerName";

    // methods

    /**
     * get the current state of the given server
     * @return Integer the current value of the state
     */
    public int getstate(String serverName) throws Exception;
    
    /**
     * set the current state of the given server
     */
    public void setstate(String serverName, Integer state) throws Exception;
    
    /**
     * get the mBean server connection for the given server
     */
    public MBeanServerConnection getServerMBeanServerConnection(String serverName) throws Exception;
    
}
