/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.management.model;

import java.util.*;
import javax.management.*;
import javax.naming.*;
import javax.naming.event.*;
import com.sun.appserv.server.util.Version;

public class J2EEDomainMdl extends J2EEEventProviderMOMdl implements NotificationListener {
    public static String DOMAINNAME;
    private static ObjectName jmImpl;
    private boolean debug = false;
    
  
    static {
        try {
            //DOMAINNAME  = com.sun.enterprise.server.ApplicationServer.getServerContext().getDefaultDomainName();
            //DOMAINNAME = java.net.InetAddress.getLocalHost().getHostName();DOMAINNAME = "com.sun.appserv";
            // By default lets set it to com.sun.appserv
            DOMAINNAME = com.sun.enterprise.management.util.J2EEModuleUtil.getDomainName(); 
            jmImpl = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        } catch (Exception e) {
            DOMAINNAME = "com.sun.appserv";
        }
    }

    private static String MANAGED_OBJECT_TYPE = "J2EEDomain";

    private String [] eventTypes = new String [] {"j2ee.object.created","j2ee.object.deleted"};

    public J2EEDomainMdl() {
        super(DOMAINNAME, false, false);
        try {
            getMBeanServer().addNotificationListener(jmImpl, this, null, "J2EEDomain");
        } catch (InstanceNotFoundException e) {
            e.printStackTrace();
        }        
    }
    public J2EEDomainMdl(String domainname) {
        super(domainname, false, false);
        DOMAINNAME = domainname;
        try {
            getMBeanServer().addNotificationListener(jmImpl, this, null, "J2EEDomain");
        } catch (InstanceNotFoundException e) {
            e.printStackTrace();
        }        
    }
    public J2EEDomainMdl(String domainname, String serverName) {
        super(domainname, serverName, false, false);
        DOMAINNAME = domainname;
        try {
            getMBeanServer().addNotificationListener(jmImpl, this, null, "J2EEDomain");
        } catch (InstanceNotFoundException e) {
            e.printStackTrace();
        }
    }
    //constructor for generic instantiation from the MBeanRegistry
    public J2EEDomainMdl(String[] location) {
        this(location[0]);
    }

/** 
* A list of all J2EE Servers in this domain. 
* @supplierCardinality 0..* 
*/ 
    public String[] getservers(){
        Set servers = findNames("j2eeType=J2EEServer");

        Iterator it = servers.iterator();
        String [] ret = new String[servers.size()];
        int i =0;
        while(it.hasNext()) {
            ret[i++] = ((ObjectName)it.next()).toString();
        }
        return ret;
    }

    public String[] geteventTypes(){
        return eventTypes;
    }

    public void handleNotification(Notification n, Object handback) {
        /*
        Need to foward the notifications of type jmx.mbean.* as j2ee.object.*
        */
        if (debug) {
        System.out.println(handback);
        System.out.println("message: " + n.getMessage());
        System.out.println("sequence: " + n.getSequenceNumber());
        System.out.println("source: " + n.getSource());
        System.out.println("timestamp: " + n.getTimeStamp());
        System.out.println("type: " + n.getType());
        System.out.println("user data: " + n.getUserData());
        System.out.println("");
        }

        if(n instanceof MBeanServerNotification) {
            MBeanServerNotification n2 = null;
            if (n.getType().equalsIgnoreCase("jmx.mbean.registered")) {
                ObjectName oname = ((MBeanServerNotification)n).getMBeanName();
                if (debug) System.out.println("MBean name: " + oname);
                if (!((String)oname.getKeyProperty("name")).equals(getname())) { // don't listen to self!
                	try {
                            Boolean b = (Boolean)getMEJBUtility().getAttribute(oname, "eventProvider");
                            if (b.booleanValue()){
                                if (debug) System.out.println("J2EEDomain adding myself as listener to " + oname);
                                getMBeanServer().addNotificationListener(oname, this, null, getname());
                            }
                	} catch (Exception e) {
                    	if (debug) e.printStackTrace();
                	}
                }
            	n2 = new MBeanServerNotification("j2ee.object.created", getobjectName(), n.getSequenceNumber(), oname);
            } else if (n.getType().equalsIgnoreCase("jmx.mbean.unregistered")) {
                n2 = new MBeanServerNotification("j2ee.object.deleted", getobjectName(), n.getSequenceNumber(), ((MBeanServerNotification)n).getMBeanName());
            }
            if (n2 != null) {
                sendNotification(n2);
                return;
            }
        }
        if (debug) System.out.println("Forwarding original notification " + n);
        sendNotification(n);
    }

    /**
     * The type of the J2EEManagedObject as specified by JSR77. The class that implements a specific type must override this method and return the appropriate type string.
     */
    public String getj2eeType() {
        return MANAGED_OBJECT_TYPE;
    }
    
    /**
     * The name of the J2EEManagedObject. All managed objects must have a unique name within the context of the management
     * domain. The name must not be null.
     */
    public String getobjectName() {
        Set s = findNames("j2eeType="+getj2eeType()+",name="+DOMAINNAME);
        Object [] objs = s.toArray();
        if (objs.length > 0) {
        	String name = ((ObjectName)objs[0]).toString();
        	return name;
        } else {
            return null;
        }
    }
    
    /**
     * The full version of the application server product.
     */
    public String getapplicationServerFullVersion() {
        return Version.getFullVersion();
    }
    
    /**
     * The version of the application server product.
     */
    public String getapplicationServerVersion() {
        return Version.getVersion();
    }
    
}
