/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.monitor.registry.spi.reconfig;

import com.sun.enterprise.admin.event.AdminEvent;

/**
 * Provides access to the thread local monitoring event. This class is 
 * used during dynamic reconfiguration of monitoring levels.
 *
 * @author Nazrul Islam
 * @since  JDK1.4
 */
public class MonitoringThreadContext {

    /**
     * Returns the monitoring event from thread local.
     *
     * @return  monitoring event from thread local
     */
    public static AdminEvent getEventFromThreadLocal() {
        return (AdminEvent) _threadLocal.get();
    }

    /**
     * Sets the monitoring event to thread local.
     *
     * @param  event  monitoring event
     */
    public static void setEventToThreadLocal(AdminEvent event) {
        _threadLocal.set(event);
    }

    /**
     * Removes the monitoring event from thread local.
     */
    public static void removeEventFromThreadLocal() {
        // only supported in J2SE 5.0
        //_threadLocal.remove();
    }

    // ---- VARIABLE(S)-PRIVATE -----------------------------------
    private static ThreadLocal _threadLocal = new ThreadLocal();
}
