/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.config.serverbeans.validation;

import java.util.Vector;
import java.util.logging.Level;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.validation.tests.StaticTest;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.CustomResource;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.ExternalJndiResource;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.MailResource;
import com.sun.enterprise.config.serverbeans.PersistenceManagerFactoryResource;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;

/**
    Class which contains Meta data for all types of attributes which is present in Validation Descriptor
 *  XML File
 *
 *  Sample
 *      <attribute name=<Name> type="address" />
 *      <attribute name=<Name> type="integer" range="low,high" />
 *      <attribute name=<Name> type="string"  max-length="length" />
    
    @author Srinivas Krishnan
    @version 2.0
*/

/* Class for attribute type Resource (to check uniqueness of jndiname across resources) */

public class AttrUniqueJNDI extends AttrType {
    
    public AttrUniqueJNDI(String name, String type, boolean optional) {
        super(name,type, optional);
    }
    
    public void validate(Object o, ValidationContext valCtx) {
        super.validate(o, valCtx);  // call to common validator first
        String jndiName = null;
        String choice = valCtx.choice;
        boolean flag = false;
        if(o == null || o.equals(""))
            return;
        jndiName = (String)o;
        if(choice.equals("ADD") && isResourceBeingUsed(valCtx.context, jndiName)){
            valCtx.result.failed(
                valCtx.smh.getLocalString(
                    getClass().getName() + ".jndiNameBeingUsed",
                    "Attribute({0}={1}) :  name already used by some other resource",
                    new Object[]{valCtx.attrName,jndiName}));
        }
            // apostrophes aren't allowed in jndi names - we catch
            // this by hard coding this check because this type
            // (AttrUniqueJNDI) doesn't take a regular expression.
            // This is an implementation limitation and is caused by
            // the way we handle xpath expressions - we use the
            // apostrophe to delimit the primary key names of
            // elements, and we don't escape the names when we get
            // them from the user. Therefore if the name were allowed
            // to contain an apostrophe the name would be incorrectly
            // split into two parts. Bug 6184639 details this problem.
        if (jndiName.indexOf("'") != -1){
            valCtx.result.failed(
                valCtx.smh.getLocalString(
                    getClass().getName() + ".invalidJndiName",
                    "Apostrophe not allowed in jndi name: {0}",
                    new Object[]{jndiName}));
        }
        
    }
    
    public boolean isResourceBeingUsed(ConfigContext context, String jndi) {
        
        int count=0;
        try {
            Resources resources  = ((Domain)context.getRootConfigBean()).getResources();
            
            AdminObjectResource[] admin = resources.getAdminObjectResource();
            ConnectorResource[] connres = resources.getConnectorResource();
            CustomResource[] custom = resources.getCustomResource();
            ExternalJndiResource[] external = resources.getExternalJndiResource();
            JdbcResource[] jdbcres = resources.getJdbcResource();
            MailResource[] mailres = resources.getMailResource();
            PersistenceManagerFactoryResource[] pers = resources.getPersistenceManagerFactoryResource();
            
            for(int i=0;i<admin.length;i++) {
                if(jndi.equals(admin[i].getJndiName())) 
                    return true;
            }
            for(int i=0;i<connres.length;i++) {
                if(jndi.equals(connres[i].getJndiName())) 
                    return true;
            }
            
            for(int i=0;i<custom.length;i++) {
                if(jndi.equals(custom[i].getJndiName())) 
                    return true;
            }
            
            for(int i=0;i<external.length;i++) {
                if(jndi.equals(external[i].getJndiName())) 
                    return true;
            }
            
            for(int i=0;i<jdbcres.length;i++) {
                if(jndi.equals(jdbcres[i].getJndiName()))
                    return true;
            }
            
            for(int i=0;i<mailres.length;i++) {
                if(jndi.equals(mailres[i].getJndiName()))
                    return true;
            }
            
            for(int i=0;i<pers.length;i++) {
                if(jndi.equals(pers[i].getJndiName())) 
                    return true;
            }
            
        } catch(ConfigException e) {
            _logger.log(Level.FINE, "domainxmlverifier_error", e);
        }
        return false;
    }
    
}
