/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.annotation;

import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;


/**
 * Provides notification when the annotation processor is visiting a 
 * new AnnotatedElement.
 *
 * @author Jerome Dochez
 */
public interface AnnotatedElementHandler {
  
    /**
     * Before annotations for an annotated element are processed, the 
     * startElement is called with the annotated element value and its type
     * 
     * @param type the annotated element type (class, field, method...)
     * @param element the annotated element we are starting to visit.
     *
     * @exception AnnotationProcessorException;
     */
    public void startElement(ElementType type, AnnotatedElement element)
        throws AnnotationProcessorException;
    
    /**
     * After annotations for an annotated element are processed, the
     * endElement is called with the annotated element value and its type
     *
     * @param type the annotated element type (class, field, method...)
     * @param element the annotated element we are done visiting.
     *
     * @exception AnnotationProcessorException;
     */
    public void endElement(ElementType type, AnnotatedElement element)
        throws AnnotationProcessorException;
    
}
