/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.annotation;

import java.util.Set;

/**
 * This interface defines the context for the annotation procesing
 * handler. There is only one context instance per AnnotationProcessor 
 * invocation.
 *
 * @author Jerome Dochez
 */
public interface ProcessingContext {
    
    /**
     * Returns the AnnotationProcessor instance this context is associated
     * with. 
     * @return annotation processor instance
     */
    public AnnotationProcessor getProcessor();    
    
    /**
     * Returns the Scanner implementation which is responsible for providing
     * access to all the .class files the processing tool needs to scan.
     * @return scanner instance 
     */
    public Scanner getProcessingInput();
    
    /**
     * Sets the Scanner implementation which is responsible for accessing 
     * all the .class files the AnnotationProcessor should process.
     */
    public void setProcessingInput(Scanner scanner);
    
    /**
     * Push a new handler on the stack of handlers. This handler will receive 
     * all the AnnotedElementHandler events until it is removed from the stack 
     * with a popHandler() call. 
     * @param handler the new events handler.
     */    
    public void pushHandler(AnnotatedElementHandler handler);
    
    /** 
     * Return the current handler (if any) receving all the annotated elements
     * start and stop events.
     * @return the top handler
     */
    public AnnotatedElementHandler getHandler();    
        
    /** 
     * Removes the top handler
     * @return the removed handler
     */
    public AnnotatedElementHandler popHandler();
    
    /** 
     * Return the top handler casted to the requested handler type
     * @param requested handler type 
     * @return the top handler
     * @throws ClassCastException if the top handler cannot be casted to 
     * the requested handler type.
     */
    public <U extends AnnotatedElementHandler> U getHandler(Class<U> handlerType)
        throws ClassCastException;

    /**
     * Sets the ErrorHandler instance for all errors/warnings that may be raised
     * during the annotation processing.
     * @param handler the annotation handler
     */
    public void setErrorHandler(ErrorHandler errorHandler);
    
    /**
     * Return the error handler for this processing context.
     * @return the error handler
     */
    public ErrorHandler getErrorHandler();
            
}
