/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.jbi.serviceengine.bridge;

import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.webservice.spi.ServiceDelegateCreationListener;
import com.sun.enterprise.webservice.spi.ServiceDelegateImpl;

/**
 * Gets notified anytime service gets created.
 * @author Manisha Umbarje
 */
public class ServiceCreationListenerImpl implements ServiceDelegateCreationListener{
    
    /** Creates a new instance of ServiceCreationListenerImpl */
    public ServiceCreationListenerImpl() {
    }
    
    /**
     * Registers listener for receiving port creation i.e getPort(..) events.
     * @serviceDelegate Service Object
     */
    public void serviceCreated(ServiceDelegateImpl serviceDelegate) {
        ServiceReferenceDescriptor serviceRef = serviceDelegate.getServiceReference();
        
        if (serviceRef==null) {
            // nothing we can do, the user probably did a new Service()
            return;
        }
        
        serviceDelegate.addListener(new PortCreationListenerImpl(serviceRef));
    }
}
