/*
 * JAXWSRuntimeEndpointHelper.java
 *
 * Created on February 2, 2006, 3:08 PM
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package com.sun.enterprise.jbi.serviceengine.bridge;

import com.sun.enterprise.jbi.serviceengine.ServiceEngineException;
import com.sun.enterprise.jbi.serviceengine.core.ServiceEngineEndpoint;
import com.sun.enterprise.webservice.EjbRuntimeEndpointInfo;
import com.sun.enterprise.webservice.JAXWSRuntimeEpiRegistry;
import com.sun.enterprise.webservice.WebServiceEjbEndpointRegistry;
import com.sun.xml.ws.spi.runtime.RuntimeEndpointInfo;
import com.sun.xml.ws.spi.runtime.WSRtObjectFactory;
import com.sun.xml.ws.spi.runtime.WebServiceContext;
import javax.xml.ws.handler.MessageContext.Scope;

/**
 *
 * @author mu125243
 */
public class JAXWSRuntimeEndpointHelper {
    
    /** Creates a new instance of JAXWSRuntimeEndpointHelper */
    public JAXWSRuntimeEndpointHelper() {
    }
    
    public static Object populateRuntimeInfo(ServiceEngineEndpoint endpt)
    throws ServiceEngineException {
        RuntimeEndpointInfo runtimeInfo = null;
        if(endpt.isImplementedByEJB()) {
            runtimeInfo = populateEjbRuntimeInfo(endpt);
        } else {
            runtimeInfo = populateWebRuntimeInfo(endpt);
        }
        
        setMessageContext(runtimeInfo);
        return runtimeInfo;
    }
    
    private static void setMessageContext(RuntimeEndpointInfo runtimeInfo) {
        if(runtimeInfo != null) {
            // Set the message context
            WebServiceContext wsCtxt = runtimeInfo.getWebServiceContext();
            javax.xml.ws.handler.MessageContext msgCtxt =
                    (javax.xml.ws.handler.MessageContext )WSRtObjectFactory.newInstance().createMessageContext();
            msgCtxt.put(javax.xml.ws.handler.MessageContext.MESSAGE_OUTBOUND_PROPERTY,Boolean.FALSE);
            msgCtxt.setScope(javax.xml.ws.handler.MessageContext.MESSAGE_OUTBOUND_PROPERTY, Scope.APPLICATION);
            wsCtxt.setMessageContext(msgCtxt);
        }
    }
    
    private static RuntimeEndpointInfo populateEjbRuntimeInfo(
            ServiceEngineEndpoint endpt) throws ServiceEngineException {
        try {
            WebServiceEjbEndpointRegistry registry =
                    WebServiceEjbEndpointRegistry.getRegistry();
            
            EjbRuntimeEndpointInfo ejbRtEndptInfo =
                    registry.getEjbWebServiceEndpoint(endpt.getURI(), "POST", null);
            
            RuntimeEndpointInfo rtEndptInfo = ejbRtEndptInfo.prepareInvocation(true);
            return rtEndptInfo;
        } catch(Exception e) {
            throw new ServiceEngineException(e.getMessage());
        }
    }
    
    private static RuntimeEndpointInfo populateWebRuntimeInfo(
            ServiceEngineEndpoint endpt) throws ServiceEngineException {
        try {
            String url = endpt.getURI();
            String contextRoot = endpt.getContextRoot();
            
            RuntimeEndpointInfo endpointInfo =
                    JAXWSRuntimeEpiRegistry.getInstance().
                    getRuntimeEndpointInfo(contextRoot, url, url);
            ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(endpt.getClassLoader());
            endpointInfo.init();
            Thread.currentThread().setContextClassLoader(prevClassLoader);
            return endpointInfo;
        } catch(Exception e) {
            throw new ServiceEngineException(e);
        }
    }
}
