/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.jbi.serviceengine.bridge.transport;

import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.jbi.serviceengine.ServiceEngineException;
import com.sun.enterprise.jbi.serviceengine.util.soap.MessageExchangeHelper;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;


/**
 *
 * @author Manisha Umbarje
 */
public class NMRClientConnection extends NMRConnection{
    
    //private QName svcQName;
    private boolean oneWay;
    private ServiceRefPortInfo portInfo;
    
    private MessageExchangeHelper meHelper;
    /** Creates a new instance of NMRClientConnection */
    
    public NMRClientConnection(ServiceRefPortInfo portInfo, boolean oneWay) {
        meHelper = new MessageExchangeHelper();
        //setServiceQName(serviceQName);
        setOneWay(oneWay);
        setServicePortInfo(portInfo);
    }
    
    /*public void setServiceQName(QName serviceQName) {
        this.svcQName = serviceQName;
    }*/
    
    
    public void setOneWay(boolean oneWay) {
        this.oneWay = oneWay;
    }
    
    public void setServicePortInfo(ServiceRefPortInfo portInfo) {
        this.portInfo = portInfo;
    }
    
    public void closeOutput() {
        try {
            SOAPMessage incomingMessage = createSOAPMessageFromOutputStream();
            
            meHelper.initializeMessageExchange(portInfo, oneWay);
            meHelper.normalizeMessage(incomingMessage, true);
            meHelper.dispatchMessage();
            
            if(meHelper.isInOutMessageExchange())
                receiveResponse();
        } catch (Exception ex) {
            ex.printStackTrace();
            // Handle Exception case, write SOAP Message to client TODO
        }
    }
    
     public void receiveResponse()
    throws ServiceEngineException {
        createSOAPMessageInputStream(meHelper.denormalizeMessage(false));
    }
    
    
}
