/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ConfigChangeFactory.java
 *
 * Created on February 19, 2004, 9:41 AM
 */

package com.sun.enterprise.config;

import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.impl.ConfigAddImpl;
import com.sun.enterprise.config.impl.ConfigUpdateImpl;
import com.sun.enterprise.config.impl.ConfigSetImpl;
import com.sun.enterprise.config.impl.ConfigDeleteImpl;

import com.sun.enterprise.config.util.LoggerHelper;

/**
 * This factory has static methods to create 
 * Configchange objects from a configbean. 
 * It creates specific ConfigChange Interfaces
 * using the implementations from the impl package.
 *
 * This factory is used by the configcontext while
 * generating config change objects during its operation.
 *
 * This factory can also be used by other modules to
 * generate configChange objects that can be serialized
 * and reapplied in a different VM
 *
 * @author  sridatta
 */
public class ConfigChangeFactory {
  
    /**
     * creates a ConfigAdd object based on the parameters.
     * This method should be used only if the configbean
     * for the xpath already exists
     *
     * @return ConfigAdd object that can be applied to a different context.
     * @param ctx from where the config bean needs to be taken
     * @param xpath of the config bean to be used for creating configAdd
     * @throws ConfigException
     */
  public static ConfigAdd createConfigAdd(ConfigContext ctx, String xpath) throws ConfigException {
      try {
        return new ConfigAddImpl(ctx, xpath);
      } catch(ConfigException ce) {
          LoggerHelper.info("ConfigChangeFactory.createConfigAdd: Error creating config Add", ce);
          throw ce;
      }
  }
  
  /**
   * This method is to be used is the config add is to be created
   * for a config bean that is still not added to the tree
   * @param parentXpath
   * @param childXpath
   * @param name
   * @param cb
   * @return
   */
  public static ConfigAdd createConfigAdd(String parentXpath, 
                            String childXpath, 
                            String name, 
                            ConfigBean cb) {
    return new ConfigAddImpl(parentXpath, childXpath, name, cb);
  }
  
  /**
   * creates a ConfigUpdate given old and new value
   * @param xpath
   * @param attrName
   * @param oldValue
   * @param newValue
   * @return
   */
  public static ConfigUpdate createConfigUpdate(String xpath, 
                            String attrName, 
                            String oldValue, 
                            String newValue) {
       return new ConfigUpdateImpl(xpath, attrName, oldValue, newValue);
  }

  /**
   * creates a ConfigSet 
   * @return
   */
  public static ConfigSet createConfigSet(String parentXpath, 
                            String name, 
                            Object cb, 
                            Object[] cbArray) {
       return new ConfigSetImpl(parentXpath, name, cb, cbArray);
  }
  
  /**
   * creates a configdelete
   */
  public static ConfigDelete createConfigDelete(String xpath) {
      return new ConfigDeleteImpl(xpath);
  }
}
