/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * DefaultConfigContextSettings.java
 *
 * Created on January 12, 2004, 11:44 AM
 */

package com.sun.enterprise.config.impl;

import com.sun.enterprise.config.pluggable.ConfigEnvironment;
import com.sun.enterprise.config.pluggable.ConfigBeansSettings;
import com.sun.enterprise.config.pluggable.ConfigBeanInterceptor;

/**
 * This class creates a default implementation of ConfigEnvironment
 * but this class has to be extended for setting 2 attributes.
 * url and rootClass return empty.
 *
 * @author  sridatta
 */
public class ConfigEnvironmentImpl implements ConfigEnvironment {
    
    private boolean _autoCommitFlag = false;
    private boolean _readOnlyFlag = true;
    private boolean _cachingEnabledFlag = false;
    private boolean _assertNotInCache = false;
    
    private ConfigBeanInterceptor _cbInterceptor = null;
    private String _url = null;
    private String _handler = "com.sun.enterprise.config.serverbeans.ServerValidationHandler";
    private String _rootClass = "com.sun.enterprise.config.serverbeans.Domain";

    
    /** Creates a new instance */
    public ConfigEnvironmentImpl() {
    }

    public boolean isAutoCommitOn() {
        return _autoCommitFlag;
    }    
    
    public void setAutoCommitOn(boolean value) {
        _autoCommitFlag = value;
    }
    
    public ConfigBeanInterceptor getConfigBeanInterceptor() {
        return _cbInterceptor;
    }
    
    public void setConfigBeanInterceptor(ConfigBeanInterceptor cbInterceptor) {
        _cbInterceptor = cbInterceptor;
    }
    
    /**
     * returns null
     * Needs to be overridden
     */
    public String getUrl() {
        return _url;
    }
    
    public void setUrl(String url) {
        _url = url;
    }
    
    public String getHandler() {
        return _handler;
    }
    
    public void setHandler(String handler) {
        _handler = handler;
    }
    
    public boolean isReadOnly() {
        return _readOnlyFlag;
    }
    
     public void setReadOnly(boolean value) {
        _readOnlyFlag = value;
    }
     
    /**
     * returns null by default.
     * Needs to be overridden
     */
    public String getRootClass() {
        return _rootClass;
    }
    
     public void setRootClass(String rootClass) {
        _rootClass = rootClass;
    }
     
    public boolean isCachingEnabled() {
        return _cachingEnabledFlag;
    }
    
    public void setCachingEnabled(boolean value) {
        _cachingEnabledFlag = value;
    }
    
    public ConfigBeansSettings getConfigBeansSettings() {
        return new ConfigBeansSettingsImpl();
    }
    
}
