/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/**
 * PROPRIETARY/CONFIDENTIAL.  Use of this product is subject to license terms.
 *
 * Copyright 2001-2002 by iPlanet/Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 */
package com.sun.enterprise.config.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import java.util.Iterator;

/**
 * A configuration change for an element. Holds xpath, list of changed 
 * attributes, their old and new values.
 */
public class ConfigUpdateImpl extends ConfigChangeImpl implements com.sun.enterprise.config.ConfigUpdate, Serializable {

   // private String xpath;
    private HashMap oldValues = new HashMap();
    private HashMap newValues = new HashMap();
    
    public ConfigUpdateImpl(String xpath, String attrName, String oldValue, String newValue) {
        this.xpath = xpath;
        addChangedAttribute(attrName, oldValue, newValue);
    }
    
    public String getConfigChangeType() {
        return TYPE_UPDATE;
    }
        
    /**
     * add attr changes to the hashmap
     */
    public void addChangedAttribute(String attrName, String oldValue, String newValue) {
        //FIXME: This solution will not work for cases involving setAttribute(A, NULL)
        // null has to be handled gracefully in future releases.
        
        if(oldValues.get(attrName) == null) {
           // if(!oldValue.equals(newValue)) {
                oldValues.put(attrName, oldValue);
                newValues.put(attrName, newValue);
           // } else {
           //     return;
           // }   
        } else if(oldValues.get(attrName).equals(newValue)) {
            oldValues.remove(attrName);
            newValues.remove(attrName);
        } else {
            newValues.put(attrName, newValue);
        }
    }
    
    public String getOldValue(String attrName) {
        return (String)oldValues.get(attrName);
    }
    
    public String getNewValue(String attrName) {
        return (String)newValues.get(attrName);
    }
    
    public Set getAttributeSet() {
        return oldValues.keySet();
    }

    public void removeAttribute(String attrName) {
        if (attrName == null) {
            throw new IllegalArgumentException("Attribute name is null");
        }
        if (oldValues.containsKey(attrName) && newValues.containsKey(attrName)) {
            oldValues.remove(attrName);
            newValues.remove(attrName);
        }
    }

    public String toString() {
        String ret = "update xpath=" +xpath +"\n";
        Set s = newValues.keySet();
        for(Iterator iter = s.iterator(); iter.hasNext();) {
            String next = (String) iter.next();
            ret+= "\t" + "attr=" + next + "   " + oldValues.get(next) + "-->" + newValues.get(next) + "\n";
        }
        return ret;
    }
    
    public String getName() {
        return null; //FIXME TBD
    }
}