/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.xml.ConnectorTagNames;
import java.util.Iterator;
import java.util.Set;

/**
 * Deployment Information for connection-definition
 *
 * <!ELEMENT connection-definition (
 * managedconnectionfactory-class, connectionfactory-intf,
 * connection-intf, config-property*, connectionfactory-impl, connection-impl
 * )>
 *
 * @author Sheetal Vartak
 */
public class ConnectionDefDescriptor extends Descriptor 
{
    private boolean isDirty = false;
    
    private String managedConnectionFactoryImpl = "";
    private Set configProperties;
    private String connectionIntf = "";
    private String connectionImpl = "";
    private String connectionfactoryImpl = "";
    private String connectionfactoryIntf = "";

    public ConnectionDefDescriptor () 
    {
        this.configProperties    = new OrderedSet();
    }

    /** 
     * copy constructor
     */
    public ConnectionDefDescriptor(ConnectionDefDescriptor other) 
    {
	super(other);
	managedConnectionFactoryImpl = other.managedConnectionFactoryImpl; // String
	connectionIntf = other.connectionIntf; // String
	connectionImpl = other.connectionImpl; // String
	connectionfactoryImpl = other.connectionfactoryImpl; // String
	connectionfactoryIntf = other.connectionfactoryIntf; // String
        configProperties = new OrderedSet();
	if (other.configProperties != null) {
	    for (Iterator i = other.configProperties.iterator(); i.hasNext();) {
	    	configProperties.add(new EnvironmentProperty((EnvironmentProperty)i.next()));
	    }
	}
    }

    /** 
     * Gets the value of ManagedconnectionFactoryImpl
     */
    public String getManagedConnectionFactoryImpl() 
    {
        return managedConnectionFactoryImpl;
    }
    
    /** 
     * Sets the value of ManagedconnectionFactoryImpl
     */
    public void setManagedConnectionFactoryImpl(String managedConnectionFactoryImpl) 
    {
        this.managedConnectionFactoryImpl = managedConnectionFactoryImpl;
	this.setDirty();
        this.changed();
    }

    /** 
     * Set of EnvironmentProperty 
     */
    public Set getConfigProperties() 
    {
        return configProperties;
    }
      
    /** 
     * Add a configProperty to the set
     */
    public void addConfigProperty(EnvironmentProperty configProperty) 
    {
	this.configProperties.add(configProperty);
	this.setDirty();
	this.changed();
    }

    /** 
     * Add a configProperty to the set
     */ 
    public void removeConfigProperty(EnvironmentProperty configProperty) 
    {
	this.configProperties.remove(configProperty);
	this.setDirty();
	this.changed();
    }
    
    /**
     * Get connection factory impl
     */
    public String getConnectionFactoryImpl()
    {
        return this.connectionfactoryImpl;
    }

    /** 
     * set connection factory impl 
     */
    public void setConnectionFactoryImpl(String cf) 
    {
	this.connectionfactoryImpl = cf;
    }

    /**
     * Get connection factory intf
     */
    public String getConnectionFactoryIntf()
    {
        return this.connectionfactoryIntf;
    }

    /** 
     * set connection factory intf
     */
    public void setConnectionFactoryIntf(String cf) 
    {
	this.connectionfactoryIntf = cf;
    }

    /**
     * Get connection intf
     */
    public String getConnectionIntf()
    {
        return this.connectionIntf;
    }

    /** 
     * set connection intf
     */
    public void setConnectionIntf(String con) 
    {
	this.connectionIntf = con;
    }

    /**
     * Get connection impl
     */
    public String getConnectionImpl()
    {
        return this.connectionImpl;
    }

    /** 
     * set connection intf
     */
    public void setConnectionImpl(String con) 
    {
	this.connectionImpl = con;
    }

    public boolean isDirty() 
    {
	return this.isDirty;
    }
    
    public void changed() 
    {
	super.changed();
    }    

    private void setDirty() {
        this.isDirty = true;
    }

 }
