/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment;

import java.util.Vector;
import java.util.Iterator;
import java.util.Observable;

/**
 * This class contains all the information for the deployment extension 
 * elements found in deployment descriptors since J2EE 1.4
 *
 * @author Jerome Dochez
 */
public class DeploymentExtensionDescriptor extends Observable {
    
    String nameSpace=null;
    boolean mustUnderstand=false;
    Vector elements;
    
    /** Creates a new instance of DeploymentExtensionDescriptor */
    public DeploymentExtensionDescriptor() {
        elements = new Vector();
    }
    
    /**
     * Sets the namespace for this deployment entension
     * @param the namespace
     */
    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
        changed();
    }
    
    /**
     * @return the namespace for this deployment extension
     */
    public String getNameSpace() {
        return nameSpace;
    }
    
    /**
     * Sets the mustUnderstand flag
     */
    public void setMustUnderstand(boolean mustUnderstand) {
        this.mustUnderstand = mustUnderstand;
        changed();
    }
    
    /**
     * @return true if this deployment extension must be understood
     */
    public boolean getMustUnderstand() {
        return mustUnderstand;
    }
    
    /**
     * Add a deployment extension element to his deployment extension
     * 
     * @param the new deployment extension
     */
    public void addElement(ExtensionElementDescriptor newElement) {
        elements.add(newElement);
        changed();
    }
    
    /**
     * @return an iterator on all the deployment extension elements
     */
    public Iterator elements() {
        return elements.iterator();
    }
    
    /**
     * @return a meaningful string about myself
     */
    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("namespace ").append(nameSpace);
        toStringBuffer.append("\nmustUnderstand = ").append(mustUnderstand);
        for(Iterator itr = elements();itr.hasNext();) {
            toStringBuffer.append("\nelement = ").append(itr.next());
        }
    }
    
    /**
     * notify our observers we have changed
     */
    private void changed() {
        setChanged();
        notifyObservers();
    }    
    
}
