/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment;

import java.util.*;

    /**
    * Objects implementing this interface allow their
    * environment properties, ejb references and resource
    * references to be read.
    * 
    *@author Danny Coward
    */

public interface JndiNameEnvironment {

    /** 
     * Return a set of environment properties.
     *
     * @return java.util.Set of EnvironmentProperty objects
     */
    public Set getEnvironmentProperties();


    /** 
     * Return the env-entry with the given name
     *
     * @return EnvironmentProperty descriptor
     */
    public EnvironmentProperty getEnvironmentPropertyByName(String name);
	
    /** 
     * Return a set of ejb reference descriptors.
     *
     * @return java.util.Set of EjbReferenceDescriptor objects
     */
    public Set getEjbReferenceDescriptors();

/** 
     * Return a set of service reference descriptors.
     *
     * @return java.util.Set of ServiceReferenceDescriptor objects
     */
	
    public Set getServiceReferenceDescriptors();
    
     
    /** 
     * Return the Service reference descriptor corresponding to 
     * the given name.
     *
     * @return ServiceReferenceDescriptor object
     */
    public ServiceReferenceDescriptor getServiceReferenceByName(String name);
    
    /** 
     * Return a set of resource reference descriptors.
     *
     * @return java.util.Set of ResourceReferenceDescriptor objects
     */
	
    public Set getResourceReferenceDescriptors();
    
     
    /** 
     * Return a set of JMS destination reference descriptors.
     *
     * @return java.util.Set of JmsDestinationReferenceDescriptor objects
     */
	
    public Set getJmsDestinationReferenceDescriptors();


    /** 
     * Return the JMS destination reference descriptor corresponding to 
     * the given name.
     *
     * @return JmsDestinationReferenceDescriptor object
     */
    public JmsDestinationReferenceDescriptor getJmsDestinationReferenceByName(String name);

    /** 
     * Return a set of message destination reference descriptors.
     *
     * @return java.util.Set of MessageDestinationReferenceDescriptor objects
     */
	
    public Set getMessageDestinationReferenceDescriptors();


    /** 
     * Return the message destination reference descriptor corresponding to 
     * the given name.
     *
     * @return MessageDestinationReferenceDescriptor object
     */
    public MessageDestinationReferenceDescriptor getMessageDestinationReferenceByName(String name);

    /**
     * Return a set of post-construct descriptors.
     *
     * @return java.util.Set of LifecycleCallbackDescriptor post-construct objects
     */
    public Set<LifecycleCallbackDescriptor> getPostConstructDescriptors();

    /**
     * Return the post-construct descriptor corresponding to
     * the given name.
     *
     * @return LifecycleCallbackDescriptor post-construct object
     */
    public LifecycleCallbackDescriptor getPostConstructDescriptorByClass(String className);

    /**
     * Return a set of pre-destroy descriptors.
     *
     * @return java.util.Set of LifecycleCallbackDescriptor pre-destroy objects
     */
    public Set<LifecycleCallbackDescriptor> getPreDestroyDescriptors();

    /**
     * Return the pre-destroy descriptor corresponding to
     * the given name.
     *
     * @return LifecycleCallbackDescriptor pre-destroy object
     */
    public LifecycleCallbackDescriptor getPreDestroyDescriptorByClass(String className);

    /**
     * Return a set of entity manager factory reference descriptors.
     */
    public Set<EntityManagerFactoryReferenceDescriptor> getEntityManagerFactoryReferenceDescriptors();

    /**
     * Return the entity manager factory reference descriptor corresponding to
     * the given name.
     */
    public EntityManagerFactoryReferenceDescriptor getEntityManagerFactoryReferenceByName(String name);


    /**
     * Return a set of entity manager reference descriptors.
     */
    public Set<EntityManagerReferenceDescriptor> getEntityManagerReferenceDescriptors();

    /**
     * Return the entity manager reference descriptor corresponding to
     * the given name.
     */
    public EntityManagerReferenceDescriptor getEntityManagerReferenceByName(String name);

    /**
     *
     */
    public List<InjectionCapable> getInjectableResourcesByClass(String className);
    public InjectionInfo getInjectionInfoByClass(String className);

}
