/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 package com.sun.enterprise.deployment;

import java.util.*;
import java.util.jar.*;
import java.io.*;
import java.util.zip.*;
import com.sun.enterprise.deployment.EnvironmentProperty;

/**
 * connector1.5
 * <!ELEMENT messagelistener (messagelistener-type, 
 *           activationspec)>
 *
 * @author Sheetal Vartak
 */
public class MessageListener extends Descriptor {

    
    private boolean isDirty = false;

    private String msgListenerType;
    private String activationSpecClass;
    private Set configProperties;

    //default constructor
    public MessageListener() {
	this.configProperties = new OrderedSet();
    }

   

    public String getMessageListenerType() {
	return msgListenerType;
    }

    public void setMessageListenerType(String msgListenerType) {
	this.msgListenerType = msgListenerType;
    }

    public String getActivationSpecClass() {
	return activationSpecClass;
    }

    public void setActivationSpecClass(String activationSpecClass) {
	this.activationSpecClass = activationSpecClass;
    }

     
    /** add a configProperty to the set
     */
    public void addConfigProperty(EnvironmentProperty configProperty) {
	this.configProperties.add(configProperty);
        this.setDirty();
        this.changed();
    }
    
    /** remove a configProperty from the set
     */ 
    public void removeConfigProperty(EnvironmentProperty configProperty) {
	this.configProperties.remove(configProperty);
        this.setDirty();
        this.changed();
    }

    /** Set of EnvironmentProperty 
     */
    public Set getConfigProperties() {
        return configProperties;
    }

    //return the msg listener name
    //FIXME.  No longer valid.  Use messagelistener-type instead of name
    public String getMessageListenerName() {
        throw new UnsupportedOperationException();
    }

    //set the msg listener name
    //FIXME.  No longer valid.  Use messagelistener-type instead of name
    public void setMessageListenerName(String msgListenerName) {
        throw new UnsupportedOperationException();
    }
  
    //////////////////////////////////////////
    //misc. methods for denoting change in data
    /////////////////////////////////////////
    public void changed() {
	super.changed();
    }    
        
    /**	
     * A flag to indicate that my data has changed since the last save.
     */
    public boolean isDirty() {
	return this.isDirty;
    }

    private void setDirty() {
        this.isDirty = true;
    }
    
    void doneOpening() {
	this.isDirty = false;
	this.changed();
    }

    void doneSaving() {
	this.isDirty = false;
	this.changed();
    }

    /** override 'setName' to set 'dirty' flag
    */
    public void setName(String name) {
	if (!this.getName().equals(name)) {
	    this.setDirty();
	    super.setName(name);
	}
    }
    
  }
