/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.annotation.context;

import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.annotation.ProcessingContext;


/**
 * This provides a context for a collection of Ejbs with the ejb class name.
 *
 * @Author Shing Wai Chan
 */
public class EjbsContext extends AnnotationContext 
        implements ComponentContext {
    
    private EjbContext[] ejbContexts;
    private String componentClassName;

    public EjbsContext(EjbDescriptor[] ejbDescs, Class ejbClass) {
        ejbContexts = new EjbContext[ejbDescs.length];
        for (int i = 0; i < ejbDescs.length ; i++) {
            ejbContexts[i] = new EjbContext(ejbDescs[i], ejbClass);
        }
        this.componentClassName = ejbClass.getName();
    }
   
    /**
     * Create a new instance of EjbContext.
     * Note that, for performance, we don't make a safe copy of array here.
     */
    public EjbsContext(EjbContext[] ejbContexts) {
        this.ejbContexts = ejbContexts;
        this.componentClassName = ejbContexts[0].getComponentClassName();
    }

    /**
     * Note that, for performance, we don't make a safe copy of array here.
     */
    public EjbContext[] getEjbContexts() {
        return ejbContexts;
    }
    
    public void endElement(ElementType type, AnnotatedElement element) {
        
        if (ElementType.TYPE.equals(type)) {
            // done with processing this class, let's pop this context
            getProcessingContext().popHandler();
        }
    }

    public String getComponentClassName() {
        return componentClassName;
    }
      
}
