/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.annotation.context;

import java.util.ArrayList;
import java.util.List;

import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.annotation.AnnotatedElementHandler;
import com.sun.enterprise.deployment.types.HandlerChainContainer;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;

/**
 * This ClientContext implementation holds a top level reference
 * to the DOL Web BundleDescriptor which will be used to populate
 * any information processed from the annotations.
 *
 * @author Shing Wai Chan
 */
public class WebBundleContext extends ResourceContainerContextImpl {

    public WebBundleContext(WebBundleDescriptor webBundleDescriptor) {
        super(webBundleDescriptor);
    }

    public WebBundleDescriptor getDescriptor() {
        return (WebBundleDescriptor)descriptor;
    }

    /**
     * This method create a context for web component(s) by using
     * descriptor(s) associated to given webComponet impl class. 
     * Return null if corresponding descriptor is not found.
     */
    public AnnotatedElementHandler createContextForWeb() {
        AnnotatedElement anTypeElement =
                this.getProcessingContext().getProcessor(
                ).getLastAnnotatedElement(ElementType.TYPE);
        WebComponentDescriptor[] webComps = null;
        if (anTypeElement != null) {
            String implClassName = ((Class)anTypeElement).getName();
            webComps = getDescriptor().getWebComponentByImplName(implClassName);
        }

        AnnotatedElementHandler aeHandler = null;
        if (webComps != null && webComps.length > 1) {
            aeHandler = new WebComponentsContext(webComps);
        } else if (webComps != null && webComps.length == 1) {
            aeHandler = new WebComponentContext(webComps[0]);
        }

        if (aeHandler != null) {
            // push a WebComponent(s)Context to stack
            this.getProcessingContext().pushHandler(aeHandler);
        }
        return aeHandler;
    }
    
    public HandlerChainContainer[] 
            getHandlerChainContainers(boolean serviceSideHandlerChain, Class declaringClass) {
        if(serviceSideHandlerChain) {
            List<WebServiceEndpoint> result = new ArrayList<WebServiceEndpoint>();            
            for (WebServiceEndpoint endpoint : getDescriptor().getWebServices().getEndpoints()) {
                if (endpoint.getWebComponentImpl().getWebComponentImplementation().equals(declaringClass.getName())) {
                    result.add(endpoint);
                }
            }            
            return(result.toArray(new HandlerChainContainer[0]));
        } else {
            List<ServiceReferenceDescriptor> result = new ArrayList<ServiceReferenceDescriptor>();
            result.addAll(getDescriptor().getServiceReferenceDescriptors());
            return(result.toArray(new HandlerChainContainer[0]));
        }
    }
}
