/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * LocalizedNode.java
 *
 * Created on August 16, 2002, 4:01 PM
 */

package com.sun.enterprise.deployment.node;

import java.util.Map;
import java.util.Iterator;
import java.util.Locale;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.w3c.dom.Node;

import com.sun.enterprise.deployment.xml.TagNames;

/**
 * This class is responsible for handling the xml lang attribute of 
 * an xml element
 *
 * @author Jerome Dochez
 */
public class LocalizedNode extends DeploymentDescriptorNode {
    
    protected String lang = null;
    protected String localizedValue = null;
    
    /**
     * @return the descriptor for this node
     */
    public Object getDescriptor() {
        return getParentNode().getDescriptor();
    }
    
    /**
     * notification of element start with attributes.
     */
    public void startElement(XMLElement element, Attributes attributes) {
        if (attributes.getLength()>0) {
            for (int i=0;i<attributes.getLength();i++) {
                if (attributes.getLocalName(i).equals(TagNames.LANG)) {
                    lang = attributes.getValue(i);
                }
            } 
        }
    }      
    
    /**
     * receives notification of the value for a particular tag
     * 
     * @param element the xml element
     * @param value it's associated value
     */
    public void setElementValue(XMLElement element, String value) {
        if (element.equals(getXMLRootTag())) {
            localizedValue=value;
        } else 
            super.setElementValue(element, value);        
    }
    
    /**
     * writes all the localized map element usign the tagname with 
     * the lang attribute to a DOM node
     */
    public void writeLocalizedMap(Node parentNode, String tagName, Map localizedMap) {
        if (localizedMap!=null) {
            for (Iterator itr = localizedMap.keySet().iterator();itr.hasNext();) {
                String lang = (String) itr.next();
                Element aLocalizedNode = (Element) appendTextChild(parentNode, tagName, (String) localizedMap.get(lang));
                if (aLocalizedNode!=null && lang!=Locale.getDefault().getLanguage()) { 
		    aLocalizedNode.setAttributeNS(TagNames.XML_NAMESPACE, TagNames.XML_NAMESPACE_PREFIX + TagNames.LANG, lang);
 		 } 
            }
        }        
    }
    
}
