/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node;

import java.util.Map;
import org.w3c.dom.Node;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.xml.EjbTagNames;
import com.sun.enterprise.deployment.xml.RuntimeTagNames;

/**
 * This class handle the method element 
 *
 * @author  Jerome Dochez
 * @version 
 */
public class MethodNode extends DeploymentDescriptorNode {
        
    /**
     * all sub-implementation of this class can use a dispatch table to map xml element to
     * method name on the descriptor class for setting the element value. 
     *  
     * @return the map with the element name as a key, the setter method as a value
     */    
    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put(EjbTagNames.EJB_NAME, "setEjbName");
        table.put(EjbTagNames.METHOD_INTF, "setEjbClassSymbol");
        table.put(EjbTagNames.METHOD_NAME, "setName");
        table.put(EjbTagNames.METHOD_PARAM, "addParameterClass");        
        return table;
    }    

    /**
     * write the method descriptor class to a query-method DOM tree and return it
     *
     * @param parent node in the DOM tree 
     * @param node name for the root element of this xml fragment      
     * @param the descriptor to write
     * @return the DOM tree top node
     */
    public Node writeDescriptor(Node parent, String nodeName, MethodDescriptor descriptor, String ejbName) {        
        Node methodNode = super.writeDescriptor(parent, nodeName, descriptor);    
        writeLocalizedDescriptions(methodNode, descriptor);
        if (ejbName != null && ejbName.length() > 0)  {
            appendTextChild(methodNode, EjbTagNames.EJB_NAME, ejbName);        
        }
        String methodIntfSymbol = descriptor.getEjbClassSymbol();
        if( (methodIntfSymbol != null) &&
            !methodIntfSymbol.equals(MethodDescriptor.EJB_BEAN) ) {
            appendTextChild(methodNode, EjbTagNames.METHOD_INTF, 
                            methodIntfSymbol);
        }
        appendTextChild(methodNode, EjbTagNames.METHOD_NAME, descriptor.getName());
        if (descriptor.getParameterClassNames()!=null) {
            Node paramsNode = appendChild(methodNode, EjbTagNames.METHOD_PARAMS);            
            writeMethodParams(paramsNode, descriptor);                
        }
        return methodNode;
    }
    
    /**
     * write the method descriptor class to a query-method DOM tree and return it
     *
     * @param parent node in the DOM tree 
     * @param node name for the root element of this xml fragment      
     * @param the descriptor to write
     * @return the DOM tree top node
     */
    public Node writeQueryMethodDescriptor(Node parent, String nodeName, MethodDescriptor descriptor) {        
        Node methodNode = super.writeDescriptor(parent, nodeName, descriptor);
        appendTextChild(methodNode, EjbTagNames.METHOD_NAME, descriptor.getName());
        Node paramsNode = appendChild(methodNode, EjbTagNames.METHOD_PARAMS);        
        writeMethodParams(paramsNode, descriptor);           
        return methodNode;
    }
    
    /**
     * write the method descriptor class to a java-method DOM tree and return it
     *
     * @param parent node in the DOM tree
     * @param node name for the root element of this xml fragment
     * @param the descriptor to write
     * @return the DOM tree top node
     */
    public Node writeJavaMethodDescriptor(Node parent, String nodeName, 
        MethodDescriptor descriptor) {
        Node methodNode = super.writeDescriptor(parent, nodeName, descriptor);
        appendTextChild(methodNode, RuntimeTagNames.METHOD_NAME, 
            descriptor.getName());    
        if (descriptor.getParameterClassNames() != null) {
            Node paramsNode = 
                appendChild(methodNode, RuntimeTagNames.METHOD_PARAMS); 
            writeMethodParams(paramsNode, descriptor);            
        }
        return methodNode;
    }   


    /**
     * writes the method parameters to the DOM Tree
     * 
     * @param the parent node for the parameters
     * @param the method descriptor
     */
    private void writeMethodParams(Node paramsNode, MethodDescriptor descriptor) {
        String[] params = descriptor.getParameterClassNames();
        if (params==null) 
            return;
        for (int i=0; i<params.length;i++) {
            appendTextChild(paramsNode, RuntimeTagNames.METHOD_PARAM, params[i]);
        }
    }
}
   
